/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.utils;

import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.gson.JsonArray;
import com.doudian.open.gson.JsonElement;
import com.doudian.open.gson.JsonObject;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.utils.Logger;
import com.doudian.open.utils.StringUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignUtil {
    private static final Logger LOG = Logger.getLogger(SignUtil.class);
    private static final Integer SIGN_METHOD_MD5 = 1;
    private static final Integer SIGN_METHOD_HMAC_SHA256 = 2;

    public static String sign(String appKey, String appSecret, String method, String timestamp, String paramJson, String v) {
        JsonObject jsonObject = JsonUtil.fromJsonAsJsonObject(paramJson);
        LinkedHashMap<String, Object> sortedMap = SignUtil.sortParamJson(jsonObject);
        String sortedParamStr = null;
        sortedParamStr = sortedMap != null ? JsonUtil.toJsonWithNull(sortedMap) : "{}";
        String signPattern = appSecret + "app_key" + appKey + "method" + method + "param_json" + sortedParamStr + "timestamp" + timestamp + "v2" + appSecret;
        LOG.info("sign pattern: %s", signPattern);
        return SignUtil.stringToMD5(signPattern);
    }

    public static String spiSign(String appKey, String appSecret, String timestamp, String paramJson, Integer signMethod) {
        JsonObject jsonObject;
        LinkedHashMap<String, Object> sortedMap;
        String sortedParamStr = "";
        if (StringUtil.isNotEmpty(paramJson) && (sortedMap = SignUtil.sortParamJson(jsonObject = JsonUtil.fromJsonAsJsonObject(paramJson))) != null) {
            sortedParamStr = JsonUtil.toJsonWithNull(sortedMap);
        }
        String signPattern = appSecret + "app_key" + appKey + "param_json" + sortedParamStr + "timestamp" + timestamp + appSecret;
        if (SIGN_METHOD_HMAC_SHA256.equals(signMethod)) {
            return SignUtil.stringToHmac(signPattern, appSecret);
        }
        return SignUtil.stringToMD5(signPattern);
    }

    private static LinkedHashMap<String, Object> sortParamJson(JsonObject paramJsonObject) {
        if (paramJsonObject == null) {
            return null;
        }
        if (paramJsonObject.size() == 0) {
            return new LinkedHashMap<String, Object>();
        }
        ArrayList<String> keys = new ArrayList<String>(paramJsonObject.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            JsonElement valueObj = paramJsonObject.get(key);
            if (valueObj instanceof JsonObject) {
                retMap.put(key, SignUtil.sortParamJson((JsonObject)valueObj));
                continue;
            }
            if (valueObj instanceof JsonArray) {
                JsonArray arrayObj = (JsonArray)valueObj;
                if (arrayObj.size() > 0 && arrayObj.get(0) instanceof JsonObject) {
                    ArrayList<LinkedHashMap<String, Object>> newList = new ArrayList<LinkedHashMap<String, Object>>();
                    for (JsonElement obj : arrayObj) {
                        if (!(obj instanceof JsonObject)) continue;
                        newList.add(SignUtil.sortParamJson((JsonObject)obj));
                    }
                    retMap.put(key, newList);
                    continue;
                }
                retMap.put(key, paramJsonObject.get(key));
                continue;
            }
            retMap.put(key, paramJsonObject.get(key));
        }
        return retMap;
    }

    public static String stringToMD5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new DoudianOpException(DoudianOpException.Code.CALC_MD5_ERROR, e);
        }
        StringBuilder md5code = new StringBuilder(new BigInteger(1, secretBytes).toString(16));
        while (md5code.length() < 32) {
            md5code.insert(0, "0");
        }
        return md5code.toString();
    }

    private static String stringToHmac(String plainText, String appSecret) {
        Mac mac;
        try {
            byte[] secret = appSecret.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(secret, "HmacSHA256");
            mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new DoudianOpException(DoudianOpException.Code.CALC_HMAC_ERROR);
        }
        byte[] plainBytes = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] digest = mac.doFinal(plainBytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

