/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DefaultDoudianOpClient;
import com.doudian.open.core.DoudianOpClient;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.DoudianOpRequestExecutor;
import com.doudian.open.core.DoudianOpResponse;
import com.doudian.open.core.GlobalConfig;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.Logger;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.Future;

public abstract class DoudianOpRequest<T>
implements DoudianOpRequestExecutor {
    private static final Logger LOG = Logger.getLogger(DoudianOpRequest.class);
    private DoudianOpClient client = DefaultDoudianOpClient.getDefaultClient();
    private DoudianOpConfig config = GlobalConfig.getGlobalConfig();
    private T param;

    public abstract String getUrlPath();

    public DoudianOpRequest() {
        Class<?> paramClass = this.getSuperClassParameterClass(this.getClass());
        try {
            this.param = paramClass.newInstance();
        }
        catch (Exception e) {
            throw new DoudianOpException(DoudianOpException.Code.INIT_REQUEST_PARAM_ERROR, e);
        }
    }

    public abstract Class<? extends DoudianOpResponse<?>> getResponseClass();

    @Override
    public <R> R execute(AccessToken accessToken) {
        long now = System.currentTimeMillis();
        Object ret = this.client.request(this, accessToken);
        LOG.info("request total cost: %d", System.currentTimeMillis() - now);
        return (R)ret;
    }

    @Override
    public <R> Future<R> asyncExecute(AccessToken accessToken) {
        return this.client.asyncRequest(this, accessToken);
    }

    private Class<?> getSuperClassParameterClass(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }

    public DoudianOpClient getClient() {
        return this.client;
    }

    public void setClient(DoudianOpClient client) {
        this.client = client;
    }

    public DoudianOpConfig getConfig() {
        return this.config;
    }

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public T getParam() {
        return this.param;
    }

    public void setParam(T param) {
        this.param = param;
    }
}

