/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenParam;
import com.doudian.open.api.token.AccessTokenRequest;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.api.token.RefreshTokenParam;
import com.doudian.open.api.token.RefreshTokenRequest;
import com.doudian.open.api.token.RefreshTokenResponse;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DefaultDoudianOpClient;
import com.doudian.open.core.DoudianOpClient;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.GlobalConfig;
import java.net.URLEncoder;

public class AccessTokenBuilder {
    public static AccessToken build(Long shopId) {
        return AccessTokenBuilder.build((DoudianOpConfig)GlobalConfig.getGlobalConfig(), (DoudianOpClient)DefaultDoudianOpClient.getDefaultClient(), shopId);
    }

    public static AccessToken build(String code) {
        return AccessTokenBuilder.build((DoudianOpConfig)GlobalConfig.getGlobalConfig(), (DoudianOpClient)DefaultDoudianOpClient.getDefaultClient(), code);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, Long shopId) {
        return AccessTokenBuilder.build(config, httpClient, null, shopId, true);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, String code) {
        return AccessTokenBuilder.build(config, httpClient, code, null, false);
    }

    public static AccessToken parse(String accessTokenStr) {
        AccessTokenResponse response = new AccessTokenResponse();
        response.setErrNo(0L);
        AccessTokenData data = new AccessTokenData();
        data.setAccessToken(accessTokenStr);
        response.setData(data);
        return AccessToken.wrap(response);
    }

    public static AccessToken refresh(AccessToken accessToken) {
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), accessToken);
    }

    public static AccessToken refresh(String refreshTokenStr) {
        AccessToken accessToken = AccessToken.wrap(null, refreshTokenStr);
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DefaultDoudianOpClient.getDefaultClient(), accessToken);
    }

    public static AccessToken refresh(DoudianOpConfig config, DoudianOpClient client, AccessToken accessToken) {
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.setConfig(config);
        request.setClient(client);
        ((RefreshTokenParam)request.getParam()).setGrantType("refresh_token");
        ((RefreshTokenParam)request.getParam()).setRefreshToken(accessToken.getRefreshToken());
        RefreshTokenResponse response = (RefreshTokenResponse)request.execute(null);
        return AccessToken.wrap(response);
    }

    private static AccessToken build(DoudianOpConfig config, DoudianOpClient client, String code, Long shopId, boolean isSelfAuth) {
        AccessTokenRequest request = new AccessTokenRequest();
        if (isSelfAuth) {
            ((AccessTokenParam)request.getParam()).setCode("");
            ((AccessTokenParam)request.getParam()).setGrantType("authorization_self");
            ((AccessTokenParam)request.getParam()).setShopId(shopId);
        } else {
            ((AccessTokenParam)request.getParam()).setCode(code);
            ((AccessTokenParam)request.getParam()).setGrantType("authorization_code");
        }
        request.setConfig(config);
        request.setClient(client);
        AccessTokenResponse resp = (AccessTokenResponse)request.execute(null);
        return AccessToken.wrap(resp);
    }

    private static String getEncodeString(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception exception) {
            return str;
        }
    }
}

