/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class MD5PasswordEncoder
implements PasswordEncoder {
    private MessageDigest md;

    public MD5PasswordEncoder() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public String encode(CharSequence rawPassword) {
        this.md.update(Utf8.encode((CharSequence)rawPassword));
        return this.toHex(this.md.digest());
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        byte[] expected = Hex.decode((CharSequence)encodedPassword);
        byte[] actual = this.md.digest(Utf8.encode((CharSequence)rawPassword));
        return this.matches(expected, actual);
    }

    private boolean matches(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < expected.length; ++i) {
            result |= expected[i] ^ actual[i];
        }
        return result == 0;
    }

    private String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(Character.forDigit((buffer[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(buffer[i] & 0xF, 16));
        }
        return sb.toString();
    }
}

