/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.cache.UserDeviceUtils;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.OrderUtil;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.dto.sendgoods.FetchTypeEnum;
import com.ella.user.api.auth.AccountService;
import com.ella.user.auth.dto.MyUserDetails;
import com.ella.user.domain.Account;
import com.ella.user.domain.OtherPlatformInfo;
import com.ella.user.domain.OtherPlatformInfoExample;
import com.ella.user.domain.User;
import com.ella.user.domain.UserBook;
import com.ella.user.domain.UserExample;
import com.ella.user.dto.BindAndLoginVo;
import com.ella.user.dto.PlatformBindMobileReq;
import com.ella.user.dto.RetCodeEnum;
import com.ella.user.dto.VisitorsDto;
import com.ella.user.dto.request.account.UnBindReq;
import com.ella.user.dto.user.CheckCodeConfirmRequest;
import com.ella.user.dto.user.EllabookRes;
import com.ella.user.dto.user.EllabookResData;
import com.ella.user.dto.user.PerfectKidInfoRequest;
import com.ella.user.dto.user.RegisterRequest;
import com.ella.user.dto.user.ResetPasswordRequest;
import com.ella.user.dto.user.Session;
import com.ella.user.dto.user.UserLoginRequest;
import com.ella.user.mapper.AccountMapper;
import com.ella.user.mapper.GoodsMapper;
import com.ella.user.mapper.NicknameCfgMapper;
import com.ella.user.mapper.OtherPlatformInfoMapper;
import com.ella.user.mapper.UserBookMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.service.OtherPlatformInfoServiceImpl;
import com.ella.user.service.auth.SecurityServiceImpl;
import com.ella.user.service.transactional.UserInfoTService;
import com.ella.user.utils.ContextUtils;
import com.ella.user.utils.DataUtils;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Service(value="accountServiceInnerImpl")
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LogManager.getLogger(AccountServiceImpl.class);
    final String GUEST_LOGIN_SUCCESS = "10001016";
    @Value(value="${ellabook.api.url}")
    private String url;
    @Autowired(required=false)
    private UserMapper userMapper;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private NicknameCfgMapper nicknameCfgMapper;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private OtherPlatformInfoServiceImpl otherPlatformInfoService;
    @Autowired
    private SecurityServiceImpl securityService;
    @Autowired
    private OtherPlatformInfoMapper otherPlatformInfoMapper;
    @Resource(name="restTemplateApp")
    private RestTemplate restTemplate;
    @Autowired
    private UserInfoTService userInfoTService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private UserBookMapper userBookMapper;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;

    public ResponseParams newPlatformBindMobile(@RequestBody PlatformBindMobileReq req) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("isAdd", true);
        Session session = this.registerForNewPlatformBind(req);
        if (Objects.isNull(session)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_UID_FAIL);
        }
        Integer b = this.otherPlatformInfoService.bindUid(session.getUid(), req.getUid(), req.getPlatformType());
        if (b == 2) {
            map.put("user", (Boolean)session);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
        }
        if (b == 0) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_UID_FAIL);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.PHONE_ALREADY_BIND);
    }

    private Session registerForNewPlatformBind(PlatformBindMobileReq req) {
        RegisterRequest registerRequest = new RegisterRequest();
        org.springframework.beans.BeanUtils.copyProperties((Object)req, (Object)registerRequest);
        registerRequest.setCheckCode(req.getChekCode());
        registerRequest.setCodeIsRequired(Boolean.valueOf(false));
        ResponseParams regiser = this.regiser(registerRequest);
        ResponseParams result = this.innerRegister(regiser, registerRequest.getCustomerName());
        if (Objects.isNull(result) || !CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return null;
        }
        try {
            return (Session)result.getData();
        }
        catch (Exception e) {
            log.error("registerForNewPlatformBind error:{}", (Throwable)e);
            return null;
        }
    }

    @EnableValidate
    public ResponseParams unBind(@RequestBody UnBindReq req) {
        log.info("method unBind request---> {}", (Object)JSONObject.toJSONString((Object)req));
        OtherPlatformInfo otherPlatformInfo = this.otherPlatformInfoMapper.selectByPrimaryKey(req.getThirdId());
        otherPlatformInfo.setUid(null);
        otherPlatformInfo.setStatus("EXCEPTION");
        int i = this.otherPlatformInfoMapper.updateByPrimaryKey(otherPlatformInfo);
        if (i == 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)i);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UN_BIND_FAIL);
    }

    @EnableValidate
    public ResponseParams platformBindMobile(@RequestBody PlatformBindMobileReq req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String cachCode = this.redisCache.get("MOBILE:CODE:" + req.getCustomerName());
        if (StringUtils.isEmpty((String)cachCode) || !req.getChekCode().equals(cachCode)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_LOSE);
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andStatusEqualTo("NORMAL").andMobileEqualTo(req.getCustomerName());
        List users = this.userMapper.selectByExample(userExample);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return this.newPlatformBindMobile(req);
        }
        Integer b = this.otherPlatformInfoService.bindUid(((User)users.get(0)).getUid(), req.getUid(), req.getPlatformType());
        if (b == 2) {
            map.put("isAdd", false);
            UserLoginRequest userLoginRequest = new UserLoginRequest();
            userLoginRequest.setPassword("123456");
            userLoginRequest.setCustomerName(req.getCustomerName());
            ResponseParams login = this.securityService.login(userLoginRequest);
            map.put("user", login.getData());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
        }
        if (b == 1) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.PHONE_ALREADY_BIND);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_UID_FAIL);
    }

    public ResponseParams otherPlatformLogin(@RequestBody BindAndLoginVo vo) {
        OtherPlatformInfo otherPlatformInfo1 = this.getOtherPlatformInfo(vo.getPlatformType(), vo.getUnionID(), vo.getUid());
        if (1 == vo.getLoginFrom()) {
            return this.doBind(vo, otherPlatformInfo1);
        }
        if (otherPlatformInfo1 == null) {
            return this.register(vo);
        }
        if (StringUtils.isNotEmpty((String)otherPlatformInfo1.getUid())) {
            User user = this.getUserInfoByuid(otherPlatformInfo1.getUid());
            UserLoginRequest userLoginRequest = new UserLoginRequest();
            userLoginRequest.setPassword("123456");
            userLoginRequest.setCustomerName(user.getMobile());
            ResponseParams login = this.securityService.login(userLoginRequest);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("isAdd", false);
            map.put("user", login.getData());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_IPHONENUM);
    }

    private ResponseParams doBind(BindAndLoginVo vo, OtherPlatformInfo otherPlatformInfo1) {
        if (Objects.nonNull(otherPlatformInfo1) && StringUtils.isNotEmpty((String)otherPlatformInfo1.getUid())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.IS_BINDING);
        }
        ResponseParams register = this.register(vo);
        if ("401019".equals(register.getCode())) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("id", (Long)register.getData());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, map);
        }
        return register;
    }

    private ResponseParams register(BindAndLoginVo vo) {
        Long aLong = this.otherPlatformInfoService.registerOtherPlatform(vo);
        if (aLong != null) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_IPHONENUM, (Object)aLong);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.BIND_INSERT_FAIL);
    }

    public OtherPlatformInfo getOtherPlatformInfo(String platformType, String unionId, String openId) {
        OtherPlatformInfo otherPlatformInfo = null;
        if ("QQ".equalsIgnoreCase(platformType)) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)unionId)) {
                otherPlatformInfo = this.selectOtherPlatformByUnionID(unionId);
            }
            if (otherPlatformInfo == null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openId)) {
                otherPlatformInfo = this.selectOtherPlatformByPid(openId);
            }
        } else if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openId)) {
            otherPlatformInfo = this.selectOtherPlatformByPid(openId);
        }
        return otherPlatformInfo;
    }

    private OtherPlatformInfo selectOtherPlatformByPid(String pid) {
        OtherPlatformInfoExample otherPlatformInfoExample = new OtherPlatformInfoExample();
        otherPlatformInfoExample.createCriteria().andPlatformIdEqualTo(pid).andStatusEqualTo("NORMAL").andUidIsNotNull();
        List list = this.otherPlatformInfoMapper.selectByExample(otherPlatformInfoExample);
        return list == null || list.size() == 0 ? null : (OtherPlatformInfo)list.get(0);
    }

    private OtherPlatformInfo selectOtherPlatformByUnionID(String unionID) {
        OtherPlatformInfoExample otherPlatformInfoExample = new OtherPlatformInfoExample();
        otherPlatformInfoExample.createCriteria().andUnionIdEqualTo(unionID).andStatusEqualTo("NORMAL");
        List list = this.otherPlatformInfoMapper.selectByExample(otherPlatformInfoExample);
        return list == null || list.size() == 0 ? null : (OtherPlatformInfo)list.get(0);
    }

    private User getUserInfoByuid(String uid) {
        UserExample userExample = new UserExample();
        userExample.createCriteria().andStatusEqualTo("NORMAL").andUidEqualTo(uid);
        List users = this.userMapper.selectByExample(userExample);
        if (CollectionUtils.isEmpty((Collection)users)) {
            throw new EllaEnglishException("500", "\u4e09\u65b9\u7ed1\u5b9a\u7528\u6237\u5f02\u5e38", "\u4e09\u65b9\u7ed1\u5b9a\u7528\u6237uid\u4e0d\u5b58\u5728");
        }
        return (User)users.get(0);
    }

    @RequestMapping(value={"v1/logout"}, method={RequestMethod.GET})
    public ResponseParams logout(@RequestParam(value="token") String token) {
        OAuth2AccessToken lastLoginToken;
        log.info("\u9000\u51fa\u767b\u5f55:{} ", (Object)token);
        if (token != null && (lastLoginToken = this.tokenStore.readAccessToken(token)) != null) {
            OAuth2Authentication oAuth2Authentication = this.tokenStore.readAuthentication(token);
            MyUserDetails myUserDetails = (MyUserDetails)oAuth2Authentication.getUserAuthentication().getPrincipal();
            String[] tmpNames = myUserDetails.getUsername().split("#");
            this.redisCache.removeOneOfList("USER_DEVICE_NO:" + tmpNames[0], tmpNames[tmpNames.length - 1]);
            this.tokenStore.removeAccessToken(lastLoginToken);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR);
    }

    @RequestMapping(value={"v1/perfectKidInfo"}, method={RequestMethod.POST})
    public ResponseParams perfectKidInfo(@RequestBody PerfectKidInfoRequest request) throws Exception {
        int i;
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (!StringUtils.isEmpty((String)checkResult)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)checkResult);
        }
        Integer age = DataUtils.getAge((String)request.getBirthday());
        User user = new User();
        user.setAge(age);
        user.setEnName(request.getNickName());
        user.setBirthday(DataUtils.strToData((String)request.getBirthday()));
        UserExample userExample = new UserExample();
        userExample.createCriteria().andUidEqualTo(request.getUid());
        if ("1".equals(request.getIsTemplate())) {
            this.nicknameCfgMapper.addOneUseNum(request.getNickName());
        }
        if ((i = this.userMapper.updateByExampleSelective(user, userExample)) > 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.UPDATE_ERROR);
    }

    @RequestMapping(value={"v1/checkCodeConfirm"}, method={RequestMethod.POST})
    public ResponseParams checkCodeConfirm(@RequestBody CheckCodeConfirmRequest request) {
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)validateRes)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        String cachCode = this.redisCache.get("MOBILE:CODE:" + request.getCustomerName());
        if (StringUtils.isEmpty((String)cachCode)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_LOSE);
        }
        if (cachCode.equals(request.getCheckCode())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_ERROR);
    }

    @RequestMapping(value={"v1/resetPassword"}, method={RequestMethod.POST})
    public ResponseParams resetPassword(@RequestBody ResetPasswordRequest request) {
        List users;
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("resetPassword input param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (StringUtils.isNotEmpty((String)request.getCheckCode())) {
            String cachCode = this.redisCache.get("MOBILE:CODE:" + request.getCustomerName());
            if (StringUtils.isEmpty((String)cachCode)) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_LOSE);
            }
            if (!cachCode.equals(request.getCheckCode())) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_ERROR);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(users = this.getUsers(request.getCustomerName())))) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.PHONE_NOT_REG);
        }
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        requestEntity.add((Object)"method", (Object)"ella.user.resetPasswordEnglish");
        request.setChannelCode("English-" + request.getChannelCode());
        requestEntity.add((Object)"content", (Object)JSONObject.toJSONString((Object)request));
        String res = (String)this.restTemplate.postForObject(this.url, (Object)requestEntity, String.class, new Object[0]);
        log.info("APP\u7528\u6237\u767b\u5f55\u8c03\u7528\u770b\u4e66\u8fd4\u56de\u7ed3\u679c:{}  ", (Object)res);
        JSONObject jb = JSON.parseObject((String)res);
        if (jb != null && "1".equals(jb.getString("status"))) {
            new UserDeviceUtils(this.redisCache).pwdChanged(request.getCustomerName());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
    }

    @PostMapping(value={"v1/applogin"})
    public ResponseParams applogin(@RequestBody UserLoginRequest request) {
        HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
        request.setChannelCode("English-" + request.getChannelCode());
        if ("1".equals(request.getLoginVerificationType()) && StringUtils.isNotEmpty((String)request.getCheckCode())) {
            return this.codeLogin(request);
        }
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        requestEntity.add((Object)"method", (Object)"ella.user.login");
        request.setDeviceNo(null);
        requestEntity.add((Object)"content", (Object)JSONObject.toJSONString((Object)request));
        log.info("APP\u7528\u6237\u767b\u5f55\u8c03\u7528\u770b\u4e66\u5165\u53c2:{} ", (Object)JSONObject.toJSONString((Object)request));
        String res = (String)this.restTemplate.postForObject(this.url, (Object)requestEntity, String.class, new Object[0]);
        log.info("APP\u7528\u6237\u767b\u5f55\u8c03\u7528\u770b\u4e66\u8fd4\u56de\u7ed3\u679c:{}  ", (Object)res);
        EllabookRes ellabookRes = (EllabookRes)JSONObject.parseObject((String)res, EllabookRes.class);
        if ("1".equals(ellabookRes.getStatus())) {
            User user = new User();
            user.setLoginTime(new Date());
            user.setLastLoginTime(new Date());
            UserExample userExample = new UserExample();
            userExample.createCriteria().andMobileEqualTo(request.getCustomerName()).andStatusEqualTo("NORMAL");
            List users = this.userMapper.selectByExample(userExample);
            if (CollectionUtils.isEmpty((Collection)users)) {
                boolean isVip = this.judgeVip(user);
                user.setMobile(request.getCustomerName());
                user.setCreateTime(new Date());
                user.setUid(ellabookRes.getData().getUid());
                user.setStatus("NORMAL");
                this.userInfoTService.insertUser(user);
                if (isVip) {
                    try {
                        this.sendUserBook(user.getUid());
                    }
                    catch (Exception e) {
                        log.error("register send userBook error", (Throwable)e);
                    }
                }
                this.addAcount(ellabookRes.getData().getUid());
                UserLoginRequest userLoginRequest = new UserLoginRequest();
                userLoginRequest.setPassword("123456");
                userLoginRequest.setCustomerName(request.getCustomerName());
                ResponseParams login = this.securityService.login(userLoginRequest);
                ((Session)login.getData()).setUid(ellabookRes.getData().getUid());
                objectObjectHashMap.put("user", login.getData());
                objectObjectHashMap.put("isAdd", true);
                return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, objectObjectHashMap);
            }
            User user1 = (User)users.get(0);
            user1.setLastLoginTime(new Date());
            this.userMapper.updateByExampleSelective(user1, userExample);
            UserLoginRequest userLoginRequest = new UserLoginRequest();
            userLoginRequest.setPassword("123456");
            userLoginRequest.setCustomerName(request.getCustomerName());
            ResponseParams login = this.securityService.login(userLoginRequest);
            ((Session)login.getData()).setUid(ellabookRes.getData().getUid());
            objectObjectHashMap.put("user", login.getData());
            objectObjectHashMap.put("isAdd", false);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, objectObjectHashMap);
        }
        if ("10001001".equals(ellabookRes.getCode())) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_FOUNT);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.LOGIN_ERROR);
    }

    private ResponseParams codeLogin(UserLoginRequest request) {
        List users;
        HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
        String cachCode = this.redisCache.get("MOBILE:CODE:" + request.getCustomerName());
        if (!request.getCheckCode().equals("1024")) {
            if (StringUtils.isEmpty((String)cachCode)) {
                return new ResponseParams(RetCodeEnum.CHECK_CODE_LOSE.getCode(), RetCodeEnum.CHECK_CODE_LOSE.getMsg());
            }
            if (!cachCode.equals(request.getCheckCode())) {
                return new ResponseParams(RetCodeEnum.CHECK_CODE_ERROR.getCode(), RetCodeEnum.CHECK_CODE_ERROR.getMsg());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(users = this.getUsers(request.getCustomerName())))) {
            RegisterRequest registerRequest = new RegisterRequest();
            registerRequest.setChannelCode("English-" + request.getChannelCode());
            registerRequest.setRegisterVerificationType("0");
            registerRequest.setCustomerName(request.getCustomerName());
            registerRequest.setClientType(request.getClientType());
            registerRequest.setCheckCode(request.getCheckCode());
            ResponseParams regiser = this.regiser(registerRequest);
            ResponseParams login = this.innerRegister(regiser, request.getCustomerName());
            String uid = null;
            try {
                uid = BeanUtils.getNestedProperty((Object)regiser, (String)"data.uid");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (regiser.getData() instanceof User) {
                ((Session)login.getData()).setUid(uid);
            } else {
                ((Session)login.getData()).setUid(uid);
            }
            objectObjectHashMap.put("user", login.getData());
            objectObjectHashMap.put("isAdd", true);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, objectObjectHashMap);
        }
        ((User)users.get(0)).setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKey((User)users.get(0));
        UserLoginRequest userLoginRequest = new UserLoginRequest();
        userLoginRequest.setPassword("123456");
        userLoginRequest.setCustomerName(request.getCustomerName());
        ResponseParams login = this.securityService.login(userLoginRequest);
        ((Session)login.getData()).setUid(((User)users.get(0)).getUid());
        objectObjectHashMap.put("user", login.getData());
        objectObjectHashMap.put("isAdd", false);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, objectObjectHashMap);
    }

    private ResponseParams<Session> innerRegister(ResponseParams regiser, String customerName) {
        if ("10001004".equals(regiser.getCode()) || "\u8be5\u8d26\u53f7\u5df2\u6ce8\u518c!".equals(regiser.getMessage())) {
            User user = new User();
            user.setMobile(customerName);
            user.setStatus("NORMAL");
            user.setCreateTime(new Date());
            user.setUpdateTime(new Date());
            user.setLoginTime(new Date());
            user.setLastLoginTime(new Date());
            EllabookResData data = (EllabookResData)regiser.getData();
            user.setUid(data.getUid());
            boolean isVip = this.judgeVip(user);
            this.userInfoTService.insertUser(user);
            if (isVip) {
                try {
                    this.sendUserBook(user.getUid());
                }
                catch (Exception e) {
                    log.error("register send userBook error", (Throwable)e);
                }
            }
            this.addAcount(data.getUid());
        }
        UserLoginRequest userLoginRequest = new UserLoginRequest();
        userLoginRequest.setPassword("123456");
        userLoginRequest.setCustomerName(customerName);
        return this.securityService.login(userLoginRequest);
    }

    private List<User> getUsers(String phone) {
        UserExample userExample = new UserExample();
        userExample.createCriteria().andMobileEqualTo(phone).andStatusEqualTo("NORMAL");
        return this.userMapper.selectByExample(userExample);
    }

    private boolean judgeVip(User user) {
        Date now = new Date();
        Date limitDate = DateUtil.stringToDate((String)"2020-07-01 00:00:00", (String)DateUtil.DEFAULT_FORMAT);
        boolean isVip = false;
        if (now.getTime() < limitDate.getTime()) {
            user.setIsVip("Y");
            user.setVipBegin(now);
            user.setVipEnd(limitDate);
            isVip = true;
        }
        return isVip;
    }

    @PostMapping(value={"/v1/register"})
    public ResponseParams regiser(@RequestBody RegisterRequest request) {
        ResponseParams x;
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (request.getCodeIsRequired().booleanValue() && (x = this.checkCode(request, checkResult)) != null) {
            return x;
        }
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        request.setRegisterVerificationType("0");
        request.setCheckCode("");
        request.setRegisterType("mobile");
        request.setChannelCode("English-" + request.getChannelCode());
        String str = JSONObject.toJSONString((Object)request);
        log.info("\u6ce8\u518c\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}  ", (Object)str);
        requestEntity.add((Object)"method", (Object)"ella.user.register");
        requestEntity.add((Object)"content", (Object)str);
        String res = (String)this.restTemplate.postForObject(this.url, (Object)requestEntity, String.class, new Object[0]);
        log.info("\u6ce8\u518c\u8c03\u7528\u770b\u4e66\u8fd4\u56de\u7ed3\u679c:{}  ", (Object)res);
        EllabookRes ellabookRes = (EllabookRes)JSONObject.parseObject((String)res, EllabookRes.class);
        if ("1".equals(ellabookRes.getStatus())) {
            String uid = ellabookRes.getData().getUid();
            User user = new User();
            user.setUid(uid);
            user.setMobile(request.getCustomerName());
            Date now = new Date();
            user.setCreateTime(now);
            user.setStatus("NORMAL");
            user.setLoginTime(now);
            user.setLastLoginTime(now);
            boolean isVip = this.judgeVip(user);
            this.userInfoTService.insertUser(user);
            this.addAcount(uid);
            UserLoginRequest userLoginRequest = new UserLoginRequest();
            userLoginRequest.setPassword("123456");
            userLoginRequest.setCustomerName(request.getCustomerName());
            ResponseParams login = this.securityService.login(userLoginRequest);
            ((Session)login.getData()).setUid(uid);
            this.redisCache.setIfAbsent("EXPERIENCE_POPUP:" + uid, (Object)uid);
            if (isVip) {
                try {
                    this.sendUserBook(uid);
                }
                catch (Exception e) {
                    log.error("register send userBook error", (Throwable)e);
                }
            }
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)login.getData());
        }
        ResponseParams responseParams = new ResponseParams();
        responseParams.setData((Object)ellabookRes.getData()).setMsg(ellabookRes.getMessage()).setCode(ellabookRes.getCode());
        return responseParams;
    }

    private void sendUserBook(String uid) {
        List codeList = this.goodsMapper.selectPicBookCodeList();
        if (codeList == null || codeList.size() == 0) {
            return;
        }
        Set codeSet = this.getUserAlreadHasBook(uid);
        ArrayList<UserBook> books = new ArrayList<UserBook>();
        for (String code : codeList) {
            if (codeSet != null && codeSet.contains(code)) continue;
            UserBook userBook = new UserBook();
            userBook.setBookCode(code);
            userBook.setId(Long.valueOf(IdWrokerUtils.nextId()));
            userBook.setStatus("NORMAL");
            userBook.setFetchType(FetchTypeEnum.GIVE.getCode());
            userBook.setCreateTime(new Date());
            userBook.setUpdateTime(new Date());
            userBook.setUid(uid);
            books.add(userBook);
        }
        if (books.size() == 0) {
            return;
        }
        this.userBookMapper.batchInsert(books);
        Integer goodsVersion = this.redisCache.getInt("free_goods_version");
        if (goodsVersion != null && goodsVersion != 0) {
            this.redisCache.set("free_user_book_version_" + uid, (Object)goodsVersion);
        }
    }

    @RequestMapping(value={"/v1/verifyUserBook"}, method={RequestMethod.POST})
    public void verifyUserBook(@RequestParam(value="uid") String uid) {
        this.sendUserBook(uid);
    }

    private Set<String> getUserAlreadHasBook(String uid) {
        return this.userBookMapper.selectPiceBookCodeSet(uid);
    }

    private ResponseParams checkCode(@RequestBody RegisterRequest request, String checkResult) {
        if (StringUtils.isNotEmpty((String)checkResult)) {
            return new ResponseParams(RetCodeEnum.CHECK_CODE_ERROR.getCode(), checkResult);
        }
        String veriCode = request.getCheckCode();
        if (StringUtils.isEmpty((String)veriCode)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.CHECK_CODE_LOSE);
        }
        String cachCode = this.redisCache.get("MOBILE:CODE:" + request.getCustomerName());
        if (!veriCode.equals(cachCode)) {
            return new ResponseParams(RetCodeEnum.CHECK_CODE_ERROR.getCode(), RetCodeEnum.CHECK_CODE_ERROR.getMsg());
        }
        return null;
    }

    private boolean addAcount(String uid) {
        Account account = new Account();
        account.setUid(uid);
        account.setCreateTime(new Date());
        account.setCreateTime(new Date());
        account.setStatus("NORMAL");
        account.setBalance(BigDecimal.ZERO);
        account.setIosBalance(BigDecimal.ZERO);
        this.accountMapper.insertSelective(account);
        return true;
    }

    public ResponseParams visitorsLogin(@RequestBody RegisterRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        request.setRegisterVerificationType("0");
        request.setChannelCode("English-" + request.getChannelCode());
        HashMap map = new HashMap();
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        requestEntity.add((Object)"method", (Object)"ella.user.login");
        requestEntity.add((Object)"content", (Object)JSONObject.toJSONString((Object)request));
        String res = (String)this.restTemplate.postForObject(this.url, (Object)requestEntity, String.class, new Object[0]);
        log.info("2.0 visitorsLogin return:{}", (Object)res);
        EllabookRes ellabookRes = (EllabookRes)JSONObject.parseObject((String)res, EllabookRes.class);
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"10001016", (CharSequence)ellabookRes.getCode())) {
            return ResponseParamUtils.build((String)ellabookRes.getCode(), (String)ellabookRes.getMessage());
        }
        User user = this.userMapper.selectByUid(ellabookRes.getData().getUid());
        if (null == user) {
            user = new User();
            user.setEnName("EN_VISITORS_ELLA");
            user.setName("EN_VISITORS_ELLA");
            user.setCreateTime(new Date());
            user.setUid(ellabookRes.getData().getUid());
            user.setMobile(this.getFakeVisitorsMobile());
            user.setStatus("NORMAL");
            user.setIsVisitor("Y");
            user.setLoginTime(new Date());
            user.setLastLoginTime(new Date());
            this.userInfoTService.insertUser(user);
            this.redisCache.setIfAbsent("EXPERIENCE_POPUP:" + user.getUid(), (Object)user.getUid());
            this.addAcount(ellabookRes.getData().getUid());
        } else {
            user.setLastLoginTime(new Date());
            this.userMapper.updateByPrimaryKeySelective(user);
        }
        VisitorsDto dto = new VisitorsDto();
        org.springframework.beans.BeanUtils.copyProperties((Object)user, (Object)dto);
        dto.setPassword("123456");
        dto.setCustomerName(user.getMobile());
        ResponseParams login = this.securityService.enVisitorsLogin(dto);
        ((Session)login.getData()).setIsVisitor(user.getIsVisitor());
        ((Session)login.getData()).setUid(ellabookRes.getData().getUid());
        result.put("user", login.getData());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    public String visitorsLoginElla(String uid) {
        User user = this.userMapper.selectByUid(uid);
        if (null == user) {
            user = new User();
            user.setEnName("EN_VISITORS_ELLA");
            user.setName("EN_VISITORS_ELLA");
            user.setCreateTime(new Date());
            user.setUid(uid);
            user.setMobile(this.getFakeVisitorsMobile());
            user.setStatus("NORMAL");
            user.setIsVisitor("Y");
            user.setLoginTime(new Date());
            user.setLastLoginTime(new Date());
            this.userInfoTService.insertUser(user);
            this.redisCache.setIfAbsent("EXPERIENCE_POPUP:" + user.getUid(), (Object)user.getUid());
            this.addAcount(uid);
        } else {
            user.setLastLoginTime(new Date());
            this.userMapper.updateByPrimaryKeySelective(user);
        }
        VisitorsDto dto = new VisitorsDto();
        org.springframework.beans.BeanUtils.copyProperties((Object)user, (Object)dto);
        dto.setPassword("123456");
        dto.setCustomerName(user.getMobile());
        ResponseParams login = this.securityService.enVisitorsLogin(dto);
        return ((Session)login.getData()).getSessionKey();
    }

    public String apploginElla(String uid, String mobile, String email) {
        List users;
        User user = new User();
        user.setLoginTime(new Date());
        user.setLastLoginTime(new Date());
        UserExample userExample = new UserExample();
        if (StringUtils.isNotBlank((String)mobile)) {
            userExample.createCriteria().andMobileEqualTo(mobile).andStatusEqualTo("NORMAL");
        }
        if (StringUtils.isNotBlank((String)email)) {
            userExample.createCriteria().andEmailEqualTo(email).andStatusEqualTo("NORMAL");
        }
        if (CollectionUtils.isEmpty((Collection)(users = this.userMapper.selectByExample(userExample)))) {
            boolean isVip = this.judgeVip(user);
            user.setMobile(mobile);
            user.setEmail(email);
            user.setCreateTime(new Date());
            user.setUid(uid);
            user.setStatus("NORMAL");
            this.userInfoTService.insertUser(user);
            if (isVip) {
                try {
                    this.sendUserBook(user.getUid());
                }
                catch (Exception e) {
                    log.error("register send userBook error", (Throwable)e);
                }
            }
            this.addAcount(uid);
        } else {
            User user1 = (User)users.get(0);
            user1.setLastLoginTime(new Date());
            this.userMapper.updateByExampleSelective(user1, userExample);
        }
        UserLoginRequest userLoginRequest = new UserLoginRequest();
        userLoginRequest.setPassword("123456");
        userLoginRequest.setCustomerName(StringUtils.isNotBlank((String)mobile) ? mobile : email);
        ResponseParams login = this.securityService.login(userLoginRequest);
        return ((Session)login.getData()).getSessionKey();
    }

    public ResponseParams<Boolean> updateEvaluationTime(String uid, Integer num) {
        int updateResult = this.userMapper.updateEvaluationTime(uid, num);
        boolean data = updateResult > 0;
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
    }

    public Integer getEvaluationTime(String uid) {
        if (StringUtils.isBlank((String)uid)) {
            return null;
        }
        int evaluationTime = this.userMapper.getEvaluationTime(uid);
        return evaluationTime;
    }

    public String registerByEllabook(String uid, String role) {
        User user;
        String isVisitor;
        String string = isVisitor = StringUtils.equalsIgnoreCase((String)"V", (String)role) ? "Y" : "";
        if (this.userMapper.getUserByUid(uid) == null && this.userMapper.insertSelective(user = User.builder().loginTime(new Date()).lastLoginTime(new Date()).mobile(this.getFakeVisitorsMobile()).createTime(new Date()).uid(uid).status("NORMAL").isVisitor(isVisitor).build()) > 0) {
            this.addAcount(uid);
            this.userMapAndMissionService.updateUserMapForFree(user.getUid(), "N");
        }
        return this.userMapper.getUserByUid(uid).getMobile();
    }

    private String getFakeVisitorsMobile() {
        String fake = IdWrokerUtils.nextId() + "";
        if (fake.length() < 0) {
            fake = OrderUtil.createNo((String)"", (Integer)1);
        }
        if (fake.length() > 20) {
            return fake.substring(0, 19);
        }
        return fake;
    }

    public ResponseParams<Boolean> logoutForInner(@RequestParam(value="username") String username, @RequestParam(value="clientRole") String clientRole) {
        log.info("logoutForInner --- username:{},clientRole:{}", (Object)username, (Object)clientRole);
        if (!("APP".equalsIgnoreCase(clientRole) || "OTS".equalsIgnoreCase(clientRole) || "VISITOR".equalsIgnoreCase(clientRole))) {
            log.info("logoutForInner -- clientRole \u4e0d\u652f\u6301");
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR);
        }
        String key = "VISITOR".equalsIgnoreCase(clientRole) ? "LAST_LOGIN:" + username : "LAST_LOGIN:" + username + "#" + clientRole;
        String token = this.redisCache.get(key);
        if (token == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        OAuth2AccessToken lastLoginToken = this.tokenStore.readAccessToken(token);
        if (lastLoginToken != null) {
            String[] tmpNames = ContextUtils.getFullName().split("#");
            this.redisCache.removeOneOfList(tmpNames[0], tmpNames[tmpNames.length - 1]);
            this.tokenStore.removeAccessToken(lastLoginToken);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }
}

