/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.transactional.impl;

import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.LexileUtil;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.resource.constants.LevelEnum;
import com.ella.user.domain.Account;
import com.ella.user.domain.User;
import com.ella.user.dto.LearnReportDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.WordFollowRecordListDto;
import com.ella.user.dto.WordQueryRecordListDto;
import com.ella.user.dto.request.userinfo.ReportWordRequest;
import com.ella.user.dto.request.userinfo.UpdateUserInfoRequest;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import com.ella.user.mapper.AccountMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.mapper.WordFollowRecordMapper;
import com.ella.user.mapper.WordQueryRecordMapper;
import com.ella.user.service.transactional.UserInfoTService;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserInfoTServiceImpl
implements UserInfoTService {
    private static final Logger log = LogManager.getLogger(UserInfoTServiceImpl.class);
    @Autowired
    UserMapper mapper;
    @Autowired
    WordQueryRecordMapper queryMapper;
    @Autowired
    WordFollowRecordMapper followMapper;
    @Autowired
    AccountMapper accountMapper;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;

    @Transactional(rollbackFor={Exception.class})
    public UserInfoDto getUserInfoById(String id, Integer isIos) {
        User user = this.mapper.selectByUid(id);
        if (null == user) {
            return null;
        }
        UserInfoDto dto = new UserInfoDto();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getEnName())) {
            dto.setEnName(dto.getMobile());
        }
        dto.setNewMapUser(Boolean.valueOf(!"Y".equalsIgnoreCase(user.getIsVip())));
        Account acc = this.accountMapper.selectByUid(dto.getUid());
        dto.setStoneNum(acc.getStoneNum());
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserInfo(UpdateUserInfoRequest request) {
        User user = new User();
        BeanUtils.copyProperties((Object)request, (Object)user);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (null != user.getBirthday()) {
            try {
                user.setBirthday(sdf.parse(sdf.format(user.getBirthday())));
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u7528\u6237\u751f\u65e5\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        }
        return this.mapper.updateByUid(user) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public LearnReportDto getLearningReport(String uid) {
        LearnReportDto dto = new LearnReportDto();
        Integer learnTime = this.mapper.selectLearnTime(uid);
        Integer wordFollowAvg = this.mapper.selectWordFollowAvg(uid);
        String questionRecord = this.mapper.selectQuestionRecord(uid);
        String learnRank = this.mapper.getLearnRank(uid);
        dto.setLearnRank(learnRank == null ? "0" : learnRank.toString() + "%");
        dto.setLearnTime(learnTime == null ? "0" : learnTime.toString());
        dto.setWordFollowAccuracyRate(wordFollowAvg == null ? "0" : wordFollowAvg.toString() + "%");
        dto.setTestAccuracyRate(questionRecord == null ? "0" : questionRecord.toString() + "%");
        dto.setLearnCount(String.valueOf(this.mapper.selectLearnCount(uid)));
        dto.setReadBookCount(String.valueOf(this.mapper.selectBookCount(uid)));
        dto.setQueryRecords(String.valueOf(this.mapper.selectQueryRecord(uid)));
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public WordFollowRecordListDto getLearnReportFollowWord(ReportWordRequest request) {
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List list = this.followMapper.selectByLearnReport(request.getUid(), request.getCourseCode(), request.getMissionCode(), request.getLevelCode());
        Long num = this.followMapper.selectNum(request.getUid(), request.getCourseCode(), request.getMissionCode(), request.getLevelCode());
        WordFollowRecordListDto dto = new WordFollowRecordListDto();
        dto.setRecordList(list);
        dto.setFollowNum(num);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public WordQueryRecordListDto getLearnReportWordQuery(ReportWordRequest request) {
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List list = this.queryMapper.selectByLearnReport(request.getUid(), request.getCourseCode(), request.getMissionCode(), request.getLevelCode());
        Long num = this.queryMapper.selectNum(request.getUid(), request.getCourseCode(), request.getMissionCode(), request.getLevelCode());
        List words = this.queryMapper.selectWords(request.getUid(), request.getLevelCode());
        if (null == words || words.isEmpty()) {
            list.forEach(query -> query.setInWordWall(false));
        } else {
            list.forEach(query -> {
                if (words.contains(query.getWord())) {
                    query.setInWordWall(true);
                } else {
                    query.setInWordWall(false);
                }
            });
        }
        WordQueryRecordListDto dto = new WordQueryRecordListDto();
        dto.setRecordList(list);
        dto.setWordNum(num);
        return dto;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Boolean updateUserLevelInfo(UpdateUserLevelRequest request) {
        User userInfo = this.mapper.selectByUid(request.getUid());
        if (userInfo == null) {
            return Boolean.FALSE;
        }
        if (StringUtils.isBlank((CharSequence)userInfo.getLevel()) || StringUtils.isBlank((CharSequence)userInfo.getLexileLevel()) || "NO".equals(request.getLexileLevel()) || LevelEnum.LV0.equealTo(userInfo.getLevel()) || LexileUtil.biggerThan((String)request.getLexileLevel(), (String)userInfo.getLexileLevel())) {
            User upUser = new User();
            upUser.setId(userInfo.getId());
            if (LexileUtil.biggerThan((String)request.getLevelCode(), (String)userInfo.getLevel())) {
                upUser.setLevel(request.getLevelCode());
            }
            if (!"NO".equals(request.getLexileLevel())) {
                upUser.setLexileLevel(request.getLexileLevel());
            }
            return this.mapper.updateByPrimaryKeySelective(upUser) > 0;
        }
        return Boolean.TRUE;
    }

    public int insertUser(User user) {
        String email;
        int result = 0;
        if (Objects.isNull(user)) {
            return result;
        }
        String mobile = user.getMobile();
        User oldUser = this.mapper.selectByMobileOrEmail(mobile, email = user.getEmail());
        if (oldUser != null) {
            return 1;
        }
        result = this.mapper.insertSelective(user);
        if (result > 0) {
            Date limitDate = DateUtil.stringToDate((String)"2020-07-01 00:00:00", (String)DateUtil.DEFAULT_FORMAT);
            Date now = new Date();
            boolean isVip = false;
            if (now.getTime() < limitDate.getTime()) {
                isVip = true;
            }
            this.userMapAndMissionService.updateUserMapForFree(user.getUid(), isVip ? "Y" : "N");
        }
        return result;
    }
}

