/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.transactional.impl;

import com.ella.user.domain.User;
import com.ella.user.dto.LearnReportDetailDto;
import com.ella.user.dto.UserCourseDto;
import com.ella.user.mapper.UserCourseMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.service.transactional.UserCourseTService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserCourseTServiceImpl
implements UserCourseTService {
    @Autowired
    UserMapper userMapper;
    @Autowired
    UserCourseMapper userCourseMapper;

    @Transactional(rollbackFor={Exception.class})
    public List<UserCourseDto> getUserCourses(String uid, String levelCode) {
        List list = this.userCourseMapper.selectByLearnReport(uid, levelCode);
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<UserCourseDto> dtoList = new ArrayList<UserCourseDto>();
        list.forEach(course -> {
            UserCourseDto dto = new UserCourseDto();
            BeanUtils.copyProperties((Object)course, (Object)dto);
            dto.setResourceType("\u8bfe\u7a0b");
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public LearnReportDetailDto getLearnReportDetail(String uid) {
        User user = this.userMapper.selectByUid(uid);
        if (null == user) {
            return null;
        }
        if (null == user.getLevel() || "".equals(user.getLevel())) {
            return null;
        }
        int level = Integer.valueOf(user.getLevel());
        ArrayList<String> levelList = new ArrayList<String>();
        for (int i = 0; i <= level; ++i) {
            levelList.add(String.valueOf(i));
        }
        List dtoList = this.getUserCourses(uid, "0");
        LearnReportDetailDto dto = new LearnReportDetailDto();
        dto.setLevelList(levelList);
        if (null != dtoList && !dtoList.isEmpty()) {
            dtoList.forEach(d -> d.setResourceType("\u8bfe\u7a0b"));
            dto.setDtoList(dtoList);
        }
        return dto;
    }
}

