/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.transactional.impl;

import com.ella.user.domain.LexileLevelHistory;
import com.ella.user.dto.LexileLevelHistoryDto;
import com.ella.user.dto.request.lexile.LexileEvaluationRequest;
import com.ella.user.dto.request.lexile.LexileLevelRequest;
import com.ella.user.mapper.LexileLevelHistoryMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.service.transactional.LexileLevelHistoryTService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LexileLevelHistoryTServiceImpl
implements LexileLevelHistoryTService {
    @Autowired
    LexileLevelHistoryMapper mapper;
    @Autowired
    UserMapper userMapper;

    @Transactional(rollbackFor={Exception.class})
    public List<LexileLevelHistoryDto> getLexileEvalHistoryList(LexileEvaluationRequest request) {
        List list = this.mapper.selectLexiles(request.getUid());
        if (null == list || list.isEmpty()) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<LexileLevelHistoryDto> dtoList = new ArrayList<LexileLevelHistoryDto>();
        list.forEach(history -> {
            LexileLevelHistoryDto dto = new LexileLevelHistoryDto();
            BeanUtils.copyProperties((Object)history, (Object)dto);
            dto.setShowTime(sdf.format(history.getCreateTime()));
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public LexileLevelHistoryDto getLexileEvalHistoryDetail(LexileEvaluationRequest request) {
        LexileLevelHistory result = this.mapper.selectCurrentLexile(request.getUid());
        if (null == result) {
            return null;
        }
        LexileLevelHistoryDto dto = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)result, (Object)dto);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dto.setShowTime(sdf.format(result.getCreateTime()));
        String lexileRank = this.userMapper.getLexileLevelRank(request.getUid(), dto.getAge().intValue());
        dto.setLexileRank(lexileRank);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public LexileLevelHistoryDto getOneLexileEvalHistoryDetail(LexileLevelRequest request) {
        LexileLevelHistory result = this.mapper.selectCurrentLexileByIdCode(request.getUid(), request.getLevelCode());
        if (null == result) {
            return null;
        }
        LexileLevelHistoryDto dto = new LexileLevelHistoryDto();
        BeanUtils.copyProperties((Object)result, (Object)dto);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dto.setShowTime(sdf.format(result.getCreateTime()));
        String lexileRank = this.userMapper.getLexileLevelRank(request.getUid(), dto.getAge().intValue());
        dto.setLexileRank(lexileRank);
        return dto;
    }
}

