/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.learn;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.EllaEnglishException;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.resource.api.MissionService;
import com.ella.resource.dto.missiondto.MissionFullDto;
import com.ella.resource.dto.request.mission.GetMissionLevelListRequest;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.api.learn.UserWordFollowService;
import com.ella.user.domain.WordFollowRecord;
import com.ella.user.domain.XfTestFollow;
import com.ella.user.dto.learn.SaveFollowRecordRequest;
import com.ella.user.dto.learn.UserFollowRecordRequest;
import com.ella.user.dto.xfyun.ReadChapterDto;
import com.ella.user.dto.xfyun.ReadWordDto;
import com.ella.user.mapper.WordFollowRecordMapper;
import com.ella.user.mapper.XfTestFollowMapper;
import com.ella.user.utils.JSonUtils;
import com.ella.user.utils.ResponseParamUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserWordFollowServiceImpl
implements UserWordFollowService {
    private static final Logger log = LogManager.getLogger(UserWordFollowServiceImpl.class);
    @Autowired
    private WordFollowRecordMapper followMapper;
    @Autowired
    private MissionService missionService;
    private String contentTypeWord = "WORD";
    private String contentTypeSentence = "SENTENCE";
    @Autowired
    private XfTestFollowMapper testfollowMapper;

    @EnableValidate
    @Transactional(rollbackFor={Exception.class})
    public ResponseParams<Boolean> saveFollowRecord(@RequestBody SaveFollowRecordRequest req) {
        log.info("saveFollowRecord -- req :{}", (Object)req);
        if (!this.contentTypeWord.equals(req.getContentType()) && !this.contentTypeSentence.equals(req.getContentType())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)false);
        }
        WordFollowRecord rec = this.getExistRecord(req);
        if (rec != null && rec != null) {
            this.deleteFollowRecord(rec);
        }
        GetMissionLevelListRequest missionReq = new GetMissionLevelListRequest();
        missionReq.setMissionCode(req.getMissionCode());
        ResponseParams missionResult = this.missionService.getMissionAndLevelListNoPage(missionReq);
        log.info("recordUserQueryRecord -- getMissionAndLevelList result:{}", (Object)missionResult);
        if (missionResult == null || missionResult.getData() == null || ((List)missionResult.getData()).isEmpty()) {
            log.info("\u5bf9\u5e94\u7684\u5173\u5361\u4e0d\u5b58\u5728\uff0cmissionCode:{}", (Object)missionReq.getMissionCode());
            throw new EllaEnglishException(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg(), null);
        }
        MissionFullDto missionDto = (MissionFullDto)((List)missionResult.getData()).get(0);
        WordFollowRecord saveRec = new WordFollowRecord();
        BeanUtils.copyProperties((Object)req, (Object)saveRec);
        Date now = Calendar.getInstance().getTime();
        saveRec.setCreateTime(now);
        saveRec.setUpdateTime(now);
        saveRec.setStatus(DataStatusEnum.NORMAL.getCode());
        saveRec.setMapCode(missionDto.getMapCode());
        saveRec.setLevelCode(missionDto.getLevelCode());
        this.followMapper.insert(saveRec);
        this.saveFollowFlow(req, saveRec);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    @RequestMapping(path={"/v1/countUserFollowRecord"}, method={RequestMethod.POST})
    public Map<String, Integer> countUserFollowRecord(String uid, String mapCode, String missionCode, Integer learnTime) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (StringUtils.isBlank((CharSequence)uid) || StringUtils.isBlank((CharSequence)mapCode) || StringUtils.isBlank((CharSequence)missionCode)) {
            return result;
        }
        Date now = new Date();
        List tmp = this.followMapper.countUserFollowRecord(uid, mapCode, missionCode, new Date(now.getTime() - (long)(learnTime * 60 * 1000)));
        if (CollectionUtils.isEmpty((Collection)tmp)) {
            return result;
        }
        tmp.forEach(m -> result.put(m.get("contentType").toString(), Integer.parseInt(m.get("num").toString())));
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean saveFollowRecordNew(@RequestBody SaveFollowRecordRequest req) {
        WordFollowRecord saveRec = new WordFollowRecord();
        BeanUtils.copyProperties((Object)req, (Object)saveRec);
        Date now = Calendar.getInstance().getTime();
        saveRec.setCreateTime(now);
        saveRec.setUpdateTime(now);
        saveRec.setStatus(DataStatusEnum.NORMAL.getCode());
        int result = this.followMapper.insert(saveRec);
        log.info("saveFollowRecordNew -- result :{}", (Object)result);
        return result > 0;
    }

    private WordFollowRecord getExistRecord(SaveFollowRecordRequest req) {
        WordFollowRecord query = new WordFollowRecord();
        query.setFollowType(req.getFollowType());
        query.setContent(req.getContent());
        query.setContentType(req.getContentType());
        query.setMissionCode(req.getMissionCode());
        query.setCourseCode(req.getCourseCode());
        query.setStatus(DataStatusEnum.NORMAL.getCode());
        query.setUid(req.getUid());
        List list = this.followMapper.selectByCondit(query);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (WordFollowRecord)list.get(0);
    }

    private void deleteFollowRecord(WordFollowRecord rec) {
        WordFollowRecord upRec = new WordFollowRecord();
        upRec.setStatus(DataStatusEnum.DELETE.getCode());
        upRec.setId(rec.getId());
        this.followMapper.updateByPrimaryKeySelective(upRec);
    }

    public ResponseParams getUserFollowRecord(@RequestBody UserFollowRecordRequest req) {
        SaveFollowRecordRequest reqx = new SaveFollowRecordRequest();
        BeanUtils.copyProperties((Object)req, (Object)reqx);
        WordFollowRecord wordFollowRecord = this.getExistRecord(reqx);
        if (wordFollowRecord != null) {
            HashMap<String, Object> data = new HashMap<String, Object>(18);
            data.put("followScore", wordFollowRecord.getDetailScore());
            data.put("voiceUrl", wordFollowRecord.getVoiceUrl());
            return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, data);
        }
        return ResponseParams.build((CommonRetCode)CommonRetCode.SUCCESS, null);
    }

    public ResponseParams<Boolean> saveUserFollowRecord(@RequestBody UserFollowRecordRequest req) {
        log.info("saveUserFollowRecord -- req :{}", (Object)req);
        if (!this.contentTypeWord.equals(req.getContentType()) && !this.contentTypeSentence.equals(req.getContentType())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)false);
        }
        SaveFollowRecordRequest reqx = new SaveFollowRecordRequest();
        BeanUtils.copyProperties((Object)req, (Object)reqx);
        WordFollowRecord rec = this.getExistRecord(reqx);
        if (rec != null) {
            this.deleteFollowRecord(rec);
        }
        WordFollowRecord saveRec = new WordFollowRecord();
        BeanUtils.copyProperties((Object)req, (Object)saveRec);
        Date now = Calendar.getInstance().getTime();
        saveRec.setCreateTime(now);
        saveRec.setUpdateTime(now);
        saveRec.setStatus(DataStatusEnum.NORMAL.getCode());
        this.followMapper.insert(saveRec);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
    }

    private void saveFollowFlow(SaveFollowRecordRequest req, WordFollowRecord saveRec) {
        XfTestFollow query = new XfTestFollow();
        query.setFollowId(Long.valueOf(saveRec.getId().longValue()));
        try {
            JSONObject json = XML.toJSONObject((String)req.getTestResult());
            if (this.contentTypeWord.equals(req.getContentType())) {
                ReadWordDto dto = (ReadWordDto)JSonUtils.toSnakeObject((String)json.getJSONObject("xml_result").getJSONObject("read_word").getJSONObject("rec_paper").getJSONObject("read_word").toString(), ReadWordDto.class);
                BeanUtils.copyProperties((Object)dto, (Object)query);
            } else if (this.contentTypeSentence.equals(req.getContentType())) {
                ReadChapterDto dto = (ReadChapterDto)JSonUtils.toSnakeObject((String)json.getJSONObject("xml_result").getJSONObject("read_sentence").getJSONObject("rec_paper").getJSONObject("read_chapter").toString(), ReadChapterDto.class);
                BeanUtils.copyProperties((Object)dto, (Object)query);
            }
        }
        catch (Exception e) {
            log.error("\u8baf\u98de\u62a5\u6587\u683c\u5f0f\u975e\u6cd5", (Throwable)e);
        }
        query.setResponseResult(req.getTestResult());
        query.setCreateTime(Calendar.getInstance().getTime());
        query.setCreateBy(req.getUid());
        query.setId(Long.valueOf(IdWrokerUtils.nextId()));
        this.testfollowMapper.insertSelective(query);
    }
}

