/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.learn;

import com.ella.common.api.dictionary.YoudaoService;
import com.ella.common.dto.dictionary.AudioTypeEnum;
import com.ella.common.dto.dictionary.DictionaryDto;
import com.ella.common.dto.dictionary.GetEnToCnTranslateRequest;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.MissionService;
import com.ella.resource.dto.ResponsePageResult;
import com.ella.resource.dto.missiondto.MissionFullDto;
import com.ella.resource.dto.request.mission.GetMissionLevelListRequest;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.api.enums.QueryTextTypeEnum;
import com.ella.user.api.learn.DictionaryService;
import com.ella.user.domain.UserWord;
import com.ella.user.domain.WordFollowRecord;
import com.ella.user.domain.WordQueryRecord;
import com.ella.user.dto.dictionary.DictionaryAndUserLearnDto;
import com.ella.user.dto.request.dictionary.QueryWordInCourseRequest;
import com.ella.user.dto.request.dictionary.QueryWordRequest;
import com.ella.user.mapper.UserWordMapper;
import com.ella.user.mapper.WordFollowRecordMapper;
import com.ella.user.mapper.WordQueryRecordMapper;
import com.ella.user.utils.ResponseParamUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DictionaryServiceImpl
implements DictionaryService {
    private static final Logger log = LogManager.getLogger(DictionaryServiceImpl.class);
    @Autowired
    private YoudaoService youdaoService;
    @Autowired
    private WordQueryRecordMapper queryRecordMapper;
    @Autowired
    private MissionService missionService;
    @Autowired
    private WordFollowRecordMapper followRecordMapper;
    @Autowired
    private UserWordMapper userWordMapper;

    @EnableValidate
    public ResponseParams<com.ella.user.dto.dictionary.DictionaryDto> queryWord(@RequestBody QueryWordRequest request) {
        log.info("queryWord --- req :{}", (Object)request);
        ResponseParams result = this.youdaoService.getEnToCnTranslate(this.buildEnToCnTransRequest(request));
        log.info("queryWord ---getEnToCnTranslate result :{}", (Object)result);
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return ResponseParams.build((String)result.getCode(), (String)result.getMessage(), null);
        }
        if (request.getType() != null && request.getType().equals(0)) {
            UserWord userWord = this.userWordMapper.selectByUidAndWord(request.getUid(), request.getWord());
            if (userWord != null) {
                userWord.setIsKnow(Integer.valueOf(0));
                userWord.setKnowTime(new Date());
                userWord.setExplains(((DictionaryDto)result.getData()).getExplains());
                this.userWordMapper.updateByPrimaryKeySelective(userWord);
            } else {
                userWord = UserWord.builder().uid(request.getUid()).word(request.getWord()).isKnow(Integer.valueOf(0)).knowTime(new Date()).sourceType(request.getSourceType()).build();
                userWord.setExplains(((DictionaryDto)result.getData()).getExplains());
                this.userWordMapper.insertSelective(userWord);
            }
        }
        com.ella.user.dto.dictionary.DictionaryDto dto = new com.ella.user.dto.dictionary.DictionaryDto();
        BeanUtils.copyProperties((Object)result.getData(), (Object)dto);
        Integer isCollected = this.userWordMapper.selectIsCollected(request.getUid(), request.getWord());
        if (isCollected == null || isCollected == 0) {
            dto.setIsCollected(Boolean.valueOf(false));
        } else {
            dto.setIsCollected(Boolean.valueOf(true));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    @EnableValidate
    public ResponseParams<DictionaryAndUserLearnDto> queryWordAndUserVoiceInCourse(@RequestBody QueryWordInCourseRequest request) {
        log.info("queryWord --- req :{}", (Object)request);
        ResponseParams result = this.youdaoService.getEnToCnTranslate(this.buildEnToCnTransRequest(request));
        log.info("queryWord ---getEnToCnTranslate result :{}", (Object)result);
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            return ResponseParams.build((String)result.getCode(), (String)result.getMessage(), null);
        }
        DictionaryAndUserLearnDto dto = new DictionaryAndUserLearnDto();
        BeanUtils.copyProperties((Object)result.getData(), (Object)dto);
        WordFollowRecord record = this.getUserFollowData(request);
        if (record != null) {
            dto.setFollowVoice(record.getVoiceUrl());
        }
        this.recordUserQueryRecord(dto, request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    private GetEnToCnTranslateRequest buildEnToCnTransRequest(QueryWordRequest request) {
        GetEnToCnTranslateRequest req = new GetEnToCnTranslateRequest();
        req.setVoice(0);
        req.setWordText(request.getWord());
        req.setAudioType(AudioTypeEnum.MP3);
        return req;
    }

    private GetEnToCnTranslateRequest buildEnToCnTransRequest(QueryWordInCourseRequest request) {
        GetEnToCnTranslateRequest req = new GetEnToCnTranslateRequest();
        req.setVoice(0);
        req.setWordText(request.getWord());
        req.setAudioType(AudioTypeEnum.MP3);
        return req;
    }

    private void recordUserQueryRecord(DictionaryAndUserLearnDto dto, QueryWordInCourseRequest request) {
        try {
            GetMissionLevelListRequest req = new GetMissionLevelListRequest();
            req.setMissionCode(request.getMissionCode());
            ResponseParams missionResult = this.missionService.getMissionAndLevelList(req);
            log.info("recordUserQueryRecord -- getMissionAndLevelList result:{}", (Object)missionResult);
            if (missionResult == null || missionResult.getData() == null || ((ResponsePageResult)missionResult.getData()).getList() == null || ((ResponsePageResult)missionResult.getData()).getList().isEmpty()) {
                return;
            }
            MissionFullDto missionDto = (MissionFullDto)((ResponsePageResult)missionResult.getData()).getList().get(0);
            WordQueryRecord record = new WordQueryRecord();
            BeanUtils.copyProperties((Object)missionDto, (Object)record);
            Date now = Calendar.getInstance().getTime();
            record.setCreateTime(now);
            record.setStatus(DataStatusEnum.NORMAL.getCode());
            record.setUid(request.getUid());
            record.setUpdateTime(now);
            record.setWord(request.getWord());
            record.setDesc(dto.getWordDesc());
            this.queryRecordMapper.insertSelective(record);
        }
        catch (Exception e) {
            log.error("recordUserQueryRecord error : ", (Throwable)e);
        }
    }

    private WordFollowRecord getUserFollowData(QueryWordInCourseRequest request) {
        WordFollowRecord query = new WordFollowRecord();
        query.setContent(request.getWord());
        query.setContentType(QueryTextTypeEnum.WORD.getCode());
        query.setMissionCode(request.getMissionCode());
        query.setCourseCode(request.getCourseCode());
        query.setStatus(DataStatusEnum.NORMAL.getCode());
        List list = this.followRecordMapper.selectByCondit(query);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (WordFollowRecord)list.get(0);
    }
}

