/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.auth;

import com.ella.user.auth.dto.MyUserDetails;
import com.ella.user.domain.UserOts;
import com.ella.user.mapper.UserMapper;
import com.ella.user.mapper.UserOtsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger log = LogManager.getLogger(UserDetailsServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserOtsMapper userOtsMapper;

    public UserDetails loadUserByUsername(@RequestParam(value="username") String username) {
        log.info("\u6839\u636e\u7528\u6237\u540d\u3010{}\u3011\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f00\u59cb...", (Object)username);
        String[] arr = username.split("#");
        if ("OTS".equals(arr[1])) {
            return this.buildOTSUserDetailsInfo(arr[0]);
        }
        return this.buildUserDetailsInfo(username, arr[0]);
    }

    private User buildOTSUserDetailsInfo(String username) {
        boolean enabled = true;
        boolean accountNonExpired = true;
        boolean credentialsNonExpired = true;
        boolean accountNonLocked = true;
        Collection authorities = this.buildOTSGrantedAuthority(username);
        UserOts userOts = this.userOtsMapper.selectByPhone(username);
        if (userOts == null) {
            throw new UsernameNotFoundException("\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728\uff01");
        }
        MyUserDetails user = new MyUserDetails(username, userOts.getPassword(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities, userOts.getUid());
        user.setMobile(userOts.getPhone());
        user.setName(userOts.getName());
        return user;
    }

    private User buildUserDetailsInfo(String username, String mobile) {
        boolean enabled = true;
        boolean accountNonExpired = true;
        boolean credentialsNonExpired = true;
        Collection authorities = this.buildGrantedAuthority(mobile);
        com.ella.user.domain.User tmpUser = this.userMapper.selectByMobile(mobile);
        String uid = null == tmpUser ? "" : tmpUser.getUid();
        MyUserDetails user = new MyUserDetails(username, "e10adc3949ba59abbe56e057f20f883e", enabled, accountNonExpired, credentialsNonExpired, !StringUtils.isEmpty((String)uid), authorities, uid);
        user.setMobile(tmpUser.getMobile());
        user.setName(tmpUser.getName());
        user.setLevelCode(tmpUser.getLevel());
        user.setAvailable(Boolean.FALSE);
        if ("Y".equalsIgnoreCase(tmpUser.getIsVip())) {
            user.setAvailable(Boolean.valueOf(new Date().before(tmpUser.getVipEnd())));
        }
        user.setIsVip(user.getAvailable() != false ? tmpUser.getIsVip() : "N");
        return user;
    }

    private Collection<? extends GrantedAuthority> buildGrantedAuthority(String username) {
        ArrayList authorities = new ArrayList();
        return authorities;
    }

    private Collection<? extends GrantedAuthority> buildOTSGrantedAuthority(String username) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_OTS"));
        return authorities;
    }
}

