/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.auth;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.cache.UserDeviceUtils;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamTl;
import com.ella.resource.config.HeadParamUtil;
import com.ella.user.api.auth.SecurityService;
import com.ella.user.auth.dto.MyUserDetails;
import com.ella.user.configure.SecurityProperties;
import com.ella.user.domain.User;
import com.ella.user.domain.UserExample;
import com.ella.user.domain.UserOts;
import com.ella.user.dto.RetCodeEnum;
import com.ella.user.dto.VisitorsDto;
import com.ella.user.dto.user.Session;
import com.ella.user.dto.user.UserLoginRequest;
import com.ella.user.mapper.UserMapper;
import com.ella.user.mapper.UserOtsMapper;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.SmsUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class SecurityServiceImpl
implements SecurityService {
    private static final Logger log = LogManager.getLogger(SecurityServiceImpl.class);
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private SecurityProperties securityProperties;
    @Resource(name="restTemplateApp")
    private RestTemplate restAppTemplate;
    @Resource(name="restTemplateOts")
    private RestTemplate restOtsTemplate;
    @Autowired
    private DistributedCache redisCache;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserOtsMapper userOtsMapper;

    @PostMapping(value={"/v1/login"})
    @EnableValidate
    public ResponseParams<Session> login(@RequestBody UserLoginRequest req) {
        log.info("\u767b\u9646\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString((Object)req));
        HeadParamTl headParam = HeadParamUtil.getHeadParamTl();
        String customerName = req.getCustomerName() + "#" + Optional.ofNullable(req.getClientRole()).orElse(Optional.ofNullable(headParam.getClientRole()).orElse("other"));
        req.setCustomerName(customerName);
        String deviceNo = headParam.getDeviceNo();
        ResponseParams returnEntity = null;
        try {
            URI uri = this.buildParamsURL(req.getCustomerName(), req.getPassword(), deviceNo);
            ResponseEntity response = null;
            response = "OTS".equals(req.getClientRole()) ? this.restOtsTemplate.exchange(uri, HttpMethod.POST, null, OAuth2AccessToken.class) : this.restAppTemplate.exchange(uri, HttpMethod.POST, null, OAuth2AccessToken.class);
            Session session = null;
            if ("OTS".equals(req.getClientRole())) {
                UserOts userOts = this.userOtsMapper.selectByPhone(customerName.split("#")[0]);
                session = this.buildSession((OAuth2AccessToken)response.getBody(), userOts.getName());
            } else {
                UserExample userExample = new UserExample();
                userExample.createCriteria().andMobileEqualTo(req.getCustomerName().split("#")[0]);
                List users = this.userMapper.selectByExample(userExample);
                session = this.buildSession((OAuth2AccessToken)response.getBody(), ((User)users.get(0)).getName());
            }
            this.storeLastLoginSessionInfo(req.getCustomerName(), ((OAuth2AccessToken)response.getBody()).getValue(), req.getClientRole());
            new UserDeviceUtils(this.redisCache).storeDeviceInfo(req.getCustomerName().split("#")[0], deviceNo);
            log.info("\u7528\u6237\uff1a" + session.getUsername() + " \u767b\u5f55\u6210\u529f\uff01sessionKey:" + session.getSessionKey());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)session);
        }
        catch (HttpClientErrorException e) {
            e.printStackTrace();
            log.error("\u7528\u6237\uff1a" + req.getCustomerName() + "\u767b\u5f55\u5931\u8d25", (Throwable)e);
            if (HttpStatus.BAD_REQUEST.value() == e.getRawStatusCode()) {
                returnEntity = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USERNAME_PASSWORD_INVALID);
            } else if (HttpStatus.UNAUTHORIZED.value() == e.getRawStatusCode()) {
                returnEntity = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USERNAME_PASSWORD_INVALID);
            }
        }
        catch (UsernameNotFoundException e) {
            log.info(req.getCustomerName() + " \u7528\u6237\u672a\u6ce8\u518c");
            returnEntity = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_FOUNT);
        }
        return returnEntity;
    }

    @RequestMapping(value={"/v1/verificationCode"})
    public ResponseParams sendVerificationCode(@RequestParam(value="phone") String phone, @RequestParam(value="type") String type) {
        int num = (int)((Math.random() * 9.0 + 1.0) * 1000.0);
        String s = this.redisCache.get("MOBILE:CODE:LOSE::" + type + phone);
        if (StringUtils.isEmpty((String)s)) {
            SmsUtil.sendMessage((String)phone, (int)num);
            log.info(phone + " \u7684\u9a8c\u8bc1\u53d1\u9001\u6210\u529f  {}", (Object)num);
            this.redisCache.set("MOBILE:CODE:" + phone, (Object)num, 300);
            this.redisCache.set("MOBILE:CODE:LOSE::" + type + phone, (Object)1, 600);
        } else {
            if ("5".equals(this.redisCache.get("MOBILE:CODE:LOSE::" + type + phone))) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.SMS_BUSY);
            }
            SmsUtil.sendMessage((String)phone, (int)num);
            log.info(phone + " \u7684\u9a8c\u8bc1\u53d1\u9001\u6210\u529f  {}", (Object)num);
            this.redisCache.set("MOBILE:CODE:" + phone, (Object)num, 300);
            this.redisCache.set("MOBILE:CODE:LOSE::" + type + phone, (Object)(Integer.valueOf(s) + 1), 600);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS);
    }

    public ResponseParams<Session> enVisitorsLogin(@RequestBody VisitorsDto dto) {
        ResponseParams returnEntity = null;
        try {
            URI uri = this.buildParamsURL(dto.getCustomerName() + "#" + "APP", dto.getPassword());
            ResponseEntity response = this.restAppTemplate.exchange(uri, HttpMethod.POST, null, OAuth2AccessToken.class);
            User user = new User();
            BeanUtils.copyProperties((Object)dto, (Object)user);
            Session session = this.buildSession((OAuth2AccessToken)response.getBody(), user.getName());
            this.storeLastLoginSessionInfo(dto.getCustomerName(), ((OAuth2AccessToken)response.getBody()).getValue(), "APP");
            log.info("\u7528\u6237\uff1a" + session.getUsername() + " \u767b\u5f55\u6210\u529f\uff01sessionKey:" + session.getSessionKey());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)session);
        }
        catch (UsernameNotFoundException e) {
            returnEntity = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USER_NOT_FOUNT);
            return returnEntity;
        }
    }

    private void storeLastLoginSessionInfo(String username, String value, String clientType) {
        try {
            this.redisCache.set(this.getLastLoginSessionInfoKey(username), (Object)value, "OTS".equals(clientType) ? this.securityProperties.getOtsTokenExpired() : this.securityProperties.getAppTokenExpired());
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u4e0a\u6b21\u767b\u5f55session\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void checkLastLoginSessionInfo(String username, String deviceId) {
        try {
            Map userinfos = (Map)this.redisCache.getBytesObject(this.getLastLoginSessionInfoKey(username));
            if (userinfos != null) {
                OAuth2AccessToken lastLoginToken;
                String lastLoginDeviceId = (String)userinfos.get("deviceId");
                String lastLoginTokenValue = (String)userinfos.get("token");
                if (StringUtils.isNotEmpty((String)deviceId) && !deviceId.equals(lastLoginDeviceId) && lastLoginTokenValue != null && (lastLoginToken = this.tokenStore.readAccessToken(lastLoginTokenValue)) != null) {
                    this.tokenStore.removeAccessToken(lastLoginToken);
                }
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4e0a\u6b21\u767b\u5f55session\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private Session buildSession(OAuth2AccessToken accessToken, String username) {
        Session session = new Session();
        OAuth2Authentication authentication = this.tokenStore.readAuthentication(accessToken);
        MyUserDetails user = (MyUserDetails)authentication.getPrincipal();
        log.info("buildSession user :{}", (Object)JSONObject.toJSONString((Object)user));
        session.setUsername(username);
        session.setUid(user.getUid());
        session.setSessionKey(accessToken.getValue());
        session.setExpiration(accessToken.getExpiration());
        return session;
    }

    private String getLastLoginSessionInfoKey(String username) {
        return "LAST_LOGIN:" + username;
    }

    private URI buildParamsURL(String username, String password, String deviceNo) {
        String oauth2Url = this.securityProperties.getAuthTokenUrl();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)oauth2Url).queryParam("username", new Object[]{username + "#" + deviceNo}).queryParam("password", new Object[]{password}).queryParam("grant_type", new Object[]{"password"});
        return builder.build().encode().toUri();
    }

    private URI buildParamsURL(String username, String password) {
        return this.buildParamsURL(username, password, HeadParamUtil.getDeviceNo());
    }
}

