/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service.account;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.frame.lock.DistributedLocker;
import com.ella.resource.api.UserMapAndMissionService;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.domain.Account;
import com.ella.user.domain.AccountExample;
import com.ella.user.domain.User;
import com.ella.user.domain.UserExample;
import com.ella.user.domain.UserStoneChangeRecord;
import com.ella.user.domain.UserStoneChangeRecordExample;
import com.ella.user.dto.RetCodeEnum;
import com.ella.user.dto.account.AccountDto;
import com.ella.user.dto.account.AccountTypeEnum;
import com.ella.user.dto.account.EventTypeEnum;
import com.ella.user.dto.account.ModifyUserEllaCoinRequest;
import com.ella.user.dto.account.ModifyUserStoneRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import com.ella.user.mapper.AccountMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.mapper.UserStoneChangeRecordMapper;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.RestTemplateUtil;
import com.ella.user.utils.ValidationUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class UserAccountServiceImpl
implements UserAccountService {
    private static final Logger log = LogManager.getLogger(UserAccountServiceImpl.class);
    @Autowired
    private DistributedCache cache;
    @Autowired
    private AccountMapper accountMapper;
    @Value(value="${account.dealflag.expiretime}")
    private int expiretime;
    @Autowired
    private DistributedLocker distributedLocker;
    @Autowired
    private UserStoneChangeRecordMapper recordMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserMapAndMissionService userMapAndMissionService;
    @Resource(name="restTemplateApp")
    private RestTemplate restTemplate;
    @Value(value="${ellabook.api.url}")
    private String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseParams<Boolean> modifyUserEllaCoin(@RequestBody ModifyUserEllaCoinRequest req) {
        log.info("modifyUserEllaCoin --- req :{}", (Object)req);
        String validateRes = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)validateRes)) {
            log.info("modifyUserEllaCoin param [{}] error.--{}", (Object)req, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        try {
            this.distributedLocker.lock("ACCOUNT:ACCOUNT_ELLA_BANLANCE_DEAL_LOCK_KEY:" + req.getUid() + req.getOrderNo(), 2);
            String isExist = this.cache.get("ACCOUNT:ELLA_BANLANCE_DEAL_KEY:" + req.getOrderNo() + req.getUid());
            if (StringUtils.isNotEmpty((CharSequence)isExist)) {
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_DEAL_REPEAT);
                return responseParams;
            }
            MultiValueMap multiValueMap = RestTemplateUtil.getMultiValueMap((String)"ella.user.getAccountBalance", (String)JSONObject.toJSONString((Object)req));
            String result = (String)this.restTemplate.postForObject(this.url, (Object)multiValueMap, String.class, new Object[0]);
            if ("0".equals(JSONObject.parseObject((String)result).getString("status"))) {
                ResponseParams responseParams = ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
                return responseParams;
            }
            Account acc = (Account)JSON.toJavaObject((JSON)JSONObject.parseObject((String)result).getJSONObject("data"), Account.class);
            BigDecimal balance = BigDecimal.ZERO;
            if (MoneyChangeTypeEnum.MINUS == req.getChangeType()) {
                balance = AccountTypeEnum.IOS_ACCOUNT == req.getApplicableObject() ? acc.getIosBalance().subtract(req.getChangeMoney()) : acc.getBalance().subtract(req.getChangeMoney());
            }
            if (balance.doubleValue() < 0.0) {
                ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_BALANCE_NOT_ENOUGH);
                return responseParams;
            }
            MultiValueMap multiValueMapModify = RestTemplateUtil.getMultiValueMap((String)"ella.user.modifyAccountBalance", (String)JSONObject.toJSONString((Object)req));
            String result1 = (String)this.restTemplate.postForObject(this.url, (Object)multiValueMapModify, String.class, new Object[0]);
            Boolean data = JSONObject.parseObject((String)result1).getBoolean("data");
            if (data.booleanValue()) {
                this.cache.set("ACCOUNT:ELLA_BANLANCE_DEAL_KEY:" + req.getOrderNo() + req.getUid(), (Object)"isExist", this.expiretime);
                ResponseParams responseParams = ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
                return responseParams;
            }
            ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_CHANGE_MONEY_ERROR);
            return responseParams;
        }
        catch (Exception e) {
            log.error("execute --- error:", (Throwable)e);
            ResponseParams responseParams = ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_CHANGE_MONEY_ERROR);
            return responseParams;
        }
        finally {
            this.distributedLocker.unlock("ACCOUNT:ACCOUNT_ELLA_BANLANCE_DEAL_LOCK_KEY:" + req.getUid() + req.getOrderNo());
        }
    }

    public ResponseParams<Boolean> modifyUserStone(@RequestBody ModifyUserStoneRequest req) {
        int count;
        log.info("modifyUserEllaCoin --- req :{}", (Object)req);
        String validateRes = ValidationUtils.validateEntity((Object)req, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)validateRes)) {
            log.info("modifyUserEllaCoin param [{}] error.--{}", (Object)req, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        AccountExample account = new AccountExample();
        account.createCriteria().andUidEqualTo(req.getUid());
        List userAccounts = this.accountMapper.selectByExample(account);
        if (userAccounts == null || userAccounts.isEmpty()) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Account acc = (Account)userAccounts.get(0);
        int stone = acc.getStoneNum();
        if (MoneyChangeTypeEnum.MINUS == req.getOpperType()) {
            if ((stone -= req.getStoneNum().intValue()) < 0) {
                return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_STONE_NOT_ENOUGH);
            }
        } else {
            stone += req.getStoneNum().intValue();
        }
        Account accountSave = new Account();
        accountSave.setId(acc.getId());
        accountSave.setUpdateTime(Calendar.getInstance().getTime());
        accountSave.setUid(req.getUid());
        accountSave.setStoneNum(Integer.valueOf(stone));
        AccountExample exam = new AccountExample();
        AccountExample.Criteria criteria = exam.createCriteria().andIdEqualTo(acc.getId()).andStoneNumEqualTo(acc.getStoneNum());
        if (MoneyChangeTypeEnum.MINUS == req.getOpperType()) {
            criteria.andStoneNumGreaterThanOrEqualTo(Integer.valueOf(0));
        }
        if ((count = this.accountMapper.updateByExampleSelective(accountSave, exam)) == 1) {
            this.saveUserStoneChangeRecord(req);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)true);
        }
        return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.ACCOUNT_ELLA_CHANGE_MONEY_ERROR);
    }

    private void saveUserStoneChangeRecord(ModifyUserStoneRequest req) {
        try {
            UserStoneChangeRecord record = new UserStoneChangeRecord();
            BeanUtils.copyProperties((Object)req, (Object)record);
            record.setCreateBy(req.getUid());
            record.setCreateTime(Calendar.getInstance().getTime());
            record.setId(Long.valueOf(IdWrokerUtils.nextId()));
            record.setOpperType(req.getOpperType().getCode());
            record.setEventType(req.getEventType().getCode());
            this.recordMapper.insertSelective(record);
        }
        catch (Exception e) {
            log.error("saveUserStoneChangeRecord - error req:{}", (Object)req, (Object)e);
        }
    }

    public ResponseParams<Boolean> checkStoneHasConsumed(@RequestParam(value="uid", required=true) String uid, @RequestParam(value="eventType", required=true) EventTypeEnum eventType, @RequestParam(value="relationId", required=true) String relationId) {
        UserStoneChangeRecordExample example = new UserStoneChangeRecordExample();
        example.createCriteria().andUidEqualTo(uid).andEventTypeEqualTo(eventType.getCode()).andRelationIdEqualTo(relationId);
        List record = this.recordMapper.selectByExample(example);
        boolean hasConsumed = CollectionUtils.isNotEmpty((Collection)record);
        return ResponseParamUtils.build((CommonRetCode)(hasConsumed ? CommonRetCode.SUCCESS : CommonRetCode.DATA_NOT_EXISTED), (Object)hasConsumed);
    }

    public AccountDto queryUserEllaCoin(@RequestParam(value="uid", required=true) String uid) {
        log.info("queryUserEllaCoin req ----{}", (Object)uid);
        Account acc = this.accountMapper.selectByUid(uid);
        if (null != acc) {
            AccountDto dto = new AccountDto();
            BeanUtils.copyProperties((Object)acc, (Object)dto);
            return dto;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateUserVipInfo(@RequestParam(value="userId") String userId, @RequestParam(value="day") int day) {
        if (StringUtils.isBlank((CharSequence)userId) || day < 0) {
            log.info("mothed updateUserVipInfo result is false: param error userId:{},day:{}", (Object)userId, (Object)day);
            return false;
        }
        try {
            this.distributedLocker.lock("ACCOUNT:MAP_MEMBER_LOCK_KEY:" + userId, 2);
            User user = this.userMapper.selectByUid(userId);
            if (Objects.isNull(user)) {
                log.info("mothed updateUserVipInfo result is false: user:{} is not exist", (Object)userId);
                Boolean bl = false;
                return bl;
            }
            User updateUser = new User();
            Date now = new Date();
            if ("Y".equalsIgnoreCase(user.getIsVip())) {
                if (user.getVipEnd().getTime() < now.getTime()) {
                    updateUser.setVipBegin(now);
                    updateUser.setVipEnd(DateUtil.plusDay((int)day, (Date)now));
                } else {
                    updateUser.setVipEnd(DateUtil.plusDay((int)day, (Date)user.getVipEnd()));
                }
            } else {
                updateUser.setIsVip("Y");
                updateUser.setVipBegin(now);
                updateUser.setVipEnd(DateUtil.plusDay((int)day, (Date)now));
            }
            UserExample example = new UserExample();
            example.createCriteria().andIdEqualTo(user.getId());
            log.info("user vip end time:{}", (Object)updateUser.getVipEnd());
            if (StringUtils.isBlank((CharSequence)user.getLevel())) {
                this.userMapAndMissionService.updateUserMapForFree(userId, "Y");
            }
            Boolean bl = this.userMapper.updateByExampleSelective(updateUser, example) > 0;
            return bl;
        }
        finally {
            this.distributedLocker.unlock("ACCOUNT:MAP_MEMBER_LOCK_KEY:" + userId);
        }
    }
}

