/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.api.UserReviewService;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.api.enums.UserReviewApprovalStatusEnum;
import com.ella.user.api.enums.UserReviewPerfectEnum;
import com.ella.user.api.enums.UserReviewTypeEnum;
import com.ella.user.domain.UserExample;
import com.ella.user.domain.UserReview;
import com.ella.user.dto.AddUserReviewRequest;
import com.ella.user.dto.ApplistUserReviewDto;
import com.ella.user.dto.ApplistUserReviewRequest;
import com.ella.user.dto.ListUserReviewRequest;
import com.ella.user.dto.UpdateUserReviewRequest;
import com.ella.user.dto.UserReviewDto;
import com.ella.user.mapper.UserMapper;
import com.ella.user.mapper.UserReviewMapper;
import com.ella.user.utils.ResponsePageResultUtils;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserReviewServiceImpl
implements UserReviewService {
    private static final Logger log = LogManager.getLogger(UserReviewServiceImpl.class);
    @Autowired
    UserReviewMapper userReviewMapper;
    @Autowired
    UserMapper userMapper;

    public ResponseParams<PageInfo<UserReviewDto>> listUserReview(@RequestBody ListUserReviewRequest request) {
        if (request == null) {
            request = new ListUserReviewRequest();
        }
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List reviewes = this.userReviewMapper.listUserReview(request);
        PageInfo data = new PageInfo(reviewes);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)data);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> addUserReview(@RequestBody AddUserReviewRequest request) {
        log.info("Add user review request - [{}]", (Object)request);
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("Add user review request param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR);
        }
        if (!UserReviewTypeEnum.contains((String)request.getReviewType()) || request.getReviewLevel() > 5 || request.getReviewLevel() < 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR);
        }
        UserReview review = new UserReview();
        Date now = new Date();
        BeanUtils.copyProperties((Object)request, (Object)review);
        review.setUserId(request.getUid());
        review.setCreateBy(review.getUserId());
        review.setCreateTime(now);
        review.setReviewTime(now);
        review.setApprovalStatus(UserReviewApprovalStatusEnum.WAIT_APPROVAL.getCode());
        review.setStatus(DataStatusEnum.NORMAL.getCode());
        review.setIsPerfect(UserReviewPerfectEnum.NO.getCode());
        int res = this.userReviewMapper.insertSelective(review);
        if (res > 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<UserReviewDto> updateUserReview(@RequestBody UpdateUserReviewRequest request) {
        log.info("update user review request - [{}]", (Object)request);
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("update user review request param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (request.getApprovalStatus() != null && !UserReviewApprovalStatusEnum.contains((String)request.getApprovalStatus())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        if (request.getIsPerfect() != null && !UserReviewPerfectEnum.contains((String)request.getIsPerfect())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        if (request.getStatus() != null && !DataStatusEnum.contains((String)request.getStatus())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR, null);
        }
        Date now = new Date();
        UserReview review = new UserReview();
        BeanUtils.copyProperties((Object)request, (Object)review);
        review.setUpdateTime(now);
        int res = this.userReviewMapper.updateByPrimaryKeySelective(review);
        if (res > 0) {
            UserReviewDto reviewDto = this.userReviewMapper.selectById(review.getId());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)reviewDto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
    }

    @EnableValidate
    public ResponseParams applistUserReview(@RequestBody ApplistUserReviewRequest request) {
        log.info("applistUserReview request - {}", (Object)request);
        ArrayList dtos = new ArrayList();
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List userReviews = this.userReviewMapper.selectByResId(request.getResId());
        userReviews.stream().forEach(item -> {
            ApplistUserReviewDto applistUserReviewDto = new ApplistUserReviewDto();
            BeanUtils.copyProperties((Object)item, (Object)applistUserReviewDto);
            Date reviewTime = item.getReviewTime();
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            applistUserReviewDto.setReviewTime(sd.format(reviewTime));
            UserExample userExample = new UserExample();
            userExample.createCriteria().andUidEqualTo(item.getUserId()).andStatusEqualTo("NORMAL");
            List users = this.userMapper.selectByExample(userExample);
            if (!CollectionUtils.isEmpty((Collection)users)) {
                BeanUtils.copyProperties(users.get(0), (Object)applistUserReviewDto);
            }
            dtos.add(applistUserReviewDto);
        });
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)ResponsePageResultUtils.build((List)userReviews, dtos));
    }
}

