/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.user.api.UserOtsService;
import com.ella.user.api.auth.AccountService;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.domain.UserOts;
import com.ella.user.dto.userots.AddUserOtsRequest;
import com.ella.user.dto.userots.EditUserOtsRequest;
import com.ella.user.dto.userots.ListUserOtsRequest;
import com.ella.user.dto.userots.UserOtsDto;
import com.ella.user.mapper.UserOtsMapper;
import com.ella.user.utils.ResponseParamUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserOtsServiceImpl
implements UserOtsService {
    private static final Logger log = LogManager.getLogger(UserOtsServiceImpl.class);
    @Autowired
    UserOtsMapper userOtsMapper;
    @Resource(name="accountServiceInnerImpl")
    private AccountService accountService;

    @EnableValidate
    public ResponseParams<Boolean> add(@RequestBody AddUserOtsRequest request) {
        UserOts userOts = this.userOtsMapper.selectByPhone(request.getPhone());
        if (userOts != null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_EXISTED);
        }
        userOts = new UserOts();
        BeanUtils.copyProperties((Object)request, (Object)userOts);
        userOts.setPassword(DigestUtils.md5DigestAsHex((byte[])userOts.getPassword().getBytes()));
        userOts.setUid(String.format("UOTS%d", IdWrokerUtils.nextId()));
        userOts.setCreateTime(new Date());
        userOts.setStatus(DataStatusEnum.NORMAL.getCode());
        int insertRow = this.userOtsMapper.insert(userOts);
        if (insertRow < 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    @EnableValidate
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> edit(@RequestBody EditUserOtsRequest request) {
        int affectRow;
        log.info("Edit OTS user request - [{}]", (Object)request);
        if (request.getStatus() != null && !DataStatusEnum.contains((String)request.getStatus())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.STATUS_ERROR);
        }
        UserOts userOts = this.userOtsMapper.selectByUid(request.getUid());
        if (userOts == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED);
        }
        log.info("Edit OTS user, origin data - [{}]", (Object)userOts);
        UserOts updateTemp = new UserOts();
        BeanUtils.copyProperties((Object)request, (Object)updateTemp);
        updateTemp.setId(userOts.getId());
        if (StringUtils.isNotBlank((CharSequence)updateTemp.getPassword())) {
            updateTemp.setPassword(DigestUtils.md5DigestAsHex((byte[])updateTemp.getPassword().getBytes()));
        }
        if ((affectRow = this.userOtsMapper.updateByPrimaryKeySelective(updateTemp)) < 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRoleCode()) && !request.getRoleCode().equals(userOts.getRoleCode())) {
            log.info("\u82e5\u7528\u6237\u767b\u9646\uff0c\u5219\u6ce8\u9500\u7528\u6237");
            this.logoutUser(userOts.getPhone());
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    public ResponseParams<PageInfo<UserOtsDto>> list(@RequestBody ListUserOtsRequest request) {
        if (request == null) {
            request = new ListUserOtsRequest();
        }
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List users = this.userOtsMapper.list(request);
        PageInfo result = new PageInfo(users);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    private void logoutUser(String username) {
        this.accountService.logoutForInner(username, "OTS");
    }
}

