/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LevelService;
import com.ella.user.api.UserInfoService;
import com.ella.user.domain.Account;
import com.ella.user.domain.User;
import com.ella.user.dto.AccountDto;
import com.ella.user.dto.LearnReportDetailDto;
import com.ella.user.dto.LearnReportDto;
import com.ella.user.dto.RetCodeEnum;
import com.ella.user.dto.UserCourseDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.WordFollowRecordListDto;
import com.ella.user.dto.WordQueryRecordListDto;
import com.ella.user.dto.request.userinfo.AreaRequest;
import com.ella.user.dto.request.userinfo.FindUserByIdRequest;
import com.ella.user.dto.request.userinfo.GetLearnReportRequest;
import com.ella.user.dto.request.userinfo.GetReportDetailRequest;
import com.ella.user.dto.request.userinfo.ListUserInfoRequest;
import com.ella.user.dto.request.userinfo.ReportWordRequest;
import com.ella.user.dto.request.userinfo.UpdateUserInfoRequest;
import com.ella.user.dto.request.userinfo.UpdateUserLevelRequest;
import com.ella.user.dto.user.UserDetailDto;
import com.ella.user.dto.user.UserListDto;
import com.ella.user.mapper.AccountMapper;
import com.ella.user.mapper.AreaMapper;
import com.ella.user.mapper.OtherPlatformInfoMapper;
import com.ella.user.mapper.UserMapper;
import com.ella.user.service.transactional.UserCourseTService;
import com.ella.user.service.transactional.UserInfoTService;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoServiceImpl
implements UserInfoService {
    private static final Logger log = LogManager.getLogger(UserInfoServiceImpl.class);
    @Autowired
    UserInfoTService userInfoTService;
    @Autowired
    UserCourseTService userCourseTSerive;
    @Autowired
    AreaMapper areaMapper;
    @Autowired
    AccountMapper accountMapper;
    @Autowired
    OtherPlatformInfoMapper otherPlatformInfoMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private LevelService levelService;

    public ResponseParams<UserInfoDto> getUserInfoById(@RequestBody FindUserByIdRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getUserInfo param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        UserInfoDto result = this.userInfoTService.getUserInfoById(request.getUid(), request.getIsIos());
        if (Objects.isNull(result)) {
            return ResponseParamUtils.build((RetCodeEnum)RetCodeEnum.USERNAME_NOT_FOUND);
        }
        result.setLevel(this.levelService.transferLexileLevel(result.getLexileLevel()));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> updateUser(@RequestBody UpdateUserInfoRequest request) {
        log.info("\u7f16\u8f91\u7528\u6237\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("updateUser param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        boolean result = this.userInfoTService.updateUserInfo(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LearnReportDto> getLearnReport(@RequestBody GetLearnReportRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u5b66\u4e60\u62a5\u544a\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReport param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LearnReportDto result = this.userInfoTService.getLearningReport(request.getUid());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<List<Map<String, Object>>> getAreaInfo(@RequestBody AreaRequest area) {
        String areaCode = area.getAreaCode();
        String areaType = "2";
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            List areaList = this.areaMapper.findAreaListByCodeAndType("", areaType);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)areaList);
        }
        String coverCode = areaCode.replaceAll("00", "");
        Integer coverCodeLength = coverCode.length();
        if (coverCodeLength == 2) {
            areaType = "3";
        }
        List areaList = this.areaMapper.findAreaListByCodeAndType(coverCode, areaType);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)areaList);
    }

    public ResponseParams<UserInfoDto> selectUserByUid(String uid) {
        if (StringUtils.isBlank((CharSequence)uid)) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        UserInfoDto result = new UserInfoDto();
        User user = this.userMapper.selectByUid(uid);
        if (null == user) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
        }
        BeanUtils.copyProperties((Object)user, (Object)result);
        if (StringUtils.isBlank((CharSequence)result.getEnName())) {
            result.setEnName(result.getMobile());
        }
        result.setNewMapUser(Boolean.valueOf(!"Y".equalsIgnoreCase(user.getIsVip())));
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LearnReportDetailDto> getLearnReportMainDetail(@RequestBody GetReportDetailRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u4f53\u9a8c\u7ea7\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReport param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LearnReportDetailDto dto = this.userCourseTSerive.getLearnReportDetail(request.getUid());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    public ResponseParams<List<UserCourseDto>> getLearnReportLVDetail(@RequestBody GetReportDetailRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237LV\u7ea7\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReportLVDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        List dto = this.userCourseTSerive.getUserCourses(request.getUid(), request.getLevelCode());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)dto);
    }

    public ResponseParams<WordFollowRecordListDto> getLearnReportFollowDetail(@RequestBody ReportWordRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u8ddf\u8bfb\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReportLVDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        WordFollowRecordListDto result = this.userInfoTService.getLearnReportFollowWord(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<WordQueryRecordListDto> getLearnReportQueryDetail(@RequestBody ReportWordRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u67e5\u8be2\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReportLVDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        WordQueryRecordListDto result = this.userInfoTService.getLearnReportWordQuery(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<Boolean> updateUserLevelInfo(@RequestBody UpdateUserLevelRequest request) {
        log.info("Update user level info - [{}]", (Object)request);
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLearnReportLVDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Boolean updateResult = this.userInfoTService.updateUserLevelInfo(request);
        return ResponseParamUtils.build((CommonRetCode)(updateResult != false ? CommonRetCode.SUCCESS : CommonRetCode.SERVER_ERROR), (Object)updateResult);
    }

    public ResponseParams<PageInfo<UserListDto>> listUserInfo(@RequestBody ListUserInfoRequest request) {
        if (request == null) {
            request = new ListUserInfoRequest();
        }
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List userList = this.userMapper.listUserInfo(request.getSearchKey(), request.getOrderBy());
        PageInfo pageInfo = new PageInfo(userList);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)pageInfo);
    }

    public ResponseParams<UserDetailDto> detail(@RequestParam(value="uid", required=true) String uid) {
        User user = this.userMapper.selectByUid(uid);
        Account account = this.accountMapper.selectByUid(uid);
        if (user == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        Integer learnTime = this.userMapper.selectLearnTime(uid);
        Integer wordCount = this.userMapper.selectWordFollowAvg(uid);
        String latestCourseName = this.userMapper.selectLatestCourseName(uid);
        UserDetailDto userDetail = new UserDetailDto();
        BeanUtils.copyProperties((Object)user, (Object)userDetail);
        if (account != null) {
            userDetail.setBalance(account.getBalance());
            userDetail.setIosBalance(account.getIosBalance());
        } else {
            userDetail.setBalance(BigDecimal.ZERO);
            userDetail.setIosBalance(BigDecimal.ZERO);
        }
        userDetail.setWordCount(Integer.valueOf(wordCount != null ? wordCount : 0));
        userDetail.setSumLearningTime(Integer.valueOf(learnTime != null ? learnTime : 0));
        userDetail.setLatestCourseName(latestCourseName);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)userDetail);
    }

    public UserInfoDto getUserByMobile(String mobile) {
        User user = this.userMapper.selectByMobile(mobile);
        UserInfoDto dto = new UserInfoDto();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        return dto;
    }

    public ResponseParams<Map<String, Integer>> getEvaluationTime(String uid) {
        if (StringUtils.isBlank((CharSequence)uid)) {
            log.info("getEvaluationTime param error,{}", (Object)uid);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        int evaluationTime = this.userMapper.getEvaluationTime(uid);
        int time = evaluationTime > 0 ? evaluationTime : 0;
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(1);
        dataMap.put("evaluationTime", time);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, dataMap);
    }

    public ResponseParams<AccountDto> getUserAccountInfo(@RequestParam(value="uid") String uid) {
        log.info("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f," + JSONObject.toJSONString((Object)uid));
        String checkResult = ValidationUtils.validateEntity((Object)uid, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getUserInfo param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        Account acc = this.accountMapper.selectByUid(uid);
        AccountDto aDto = new AccountDto();
        if (null != acc) {
            BeanUtils.copyProperties((Object)acc, (Object)aDto);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)aDto);
    }
}

