/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.api.UserFeedbackService;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.api.enums.UserFeedbackApprovalStatusEnum;
import com.ella.user.domain.UserFeedback;
import com.ella.user.domain.UserFeedbackHandleRecord;
import com.ella.user.dto.AddUserFeedbackHandleRecordRequest;
import com.ella.user.dto.AddUserFeedbackRequest;
import com.ella.user.dto.GetUserFeedbackDetailRequest;
import com.ella.user.dto.ListUserFeedbackRequest;
import com.ella.user.dto.UserFeedbackDto;
import com.ella.user.dto.UserFeedbackHandleRecordDto;
import com.ella.user.mapper.UserFeedbackHandleRecordMapper;
import com.ella.user.mapper.UserFeedbackMapper;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserFeedbackServiceImpl
implements UserFeedbackService {
    private static final Logger log = LogManager.getLogger(UserFeedbackServiceImpl.class);
    @Autowired
    UserFeedbackMapper userFeedbackMapper;
    @Autowired
    UserFeedbackHandleRecordMapper userFeedbackHandleRecordMapper;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> feedback(@RequestBody AddUserFeedbackRequest feedback) {
        log.info("User feedback receive feedback - [{}]", (Object)feedback);
        String validateRes = ValidationUtils.validateEntity((Object)feedback, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("User feedback param [{}] error.--{}", (Object)feedback, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, (Object)Boolean.FALSE);
        }
        Date now = new Date();
        UserFeedback userFeedback = new UserFeedback();
        BeanUtils.copyProperties((Object)feedback, (Object)userFeedback);
        userFeedback.setApprovalStatus(UserFeedbackApprovalStatusEnum.WAIT_APPROVA.getCode());
        userFeedback.setCreateTime(now);
        userFeedback.setStatus(DataStatusEnum.NORMAL.getCode());
        int insertRows = this.userFeedbackMapper.insertSelective(userFeedback);
        if (insertRows < 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, (Object)Boolean.FALSE);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    public ResponseParams<PageInfo<UserFeedbackDto>> listUserFeedback(@RequestBody ListUserFeedbackRequest request) {
        if (request == null) {
            request = new ListUserFeedbackRequest();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getContent())) {
            request.setContent("%" + request.getContent() + "%");
        }
        PageHelper.startPage((int)request.getPageNo(), (int)request.getPageSize());
        List feedbacks = this.userFeedbackMapper.listUserFeedback(request);
        PageInfo pageInfo = new PageInfo(feedbacks);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)pageInfo);
    }

    public ResponseParams<UserFeedbackDto> detail(@RequestBody GetUserFeedbackDetailRequest request) {
        if (request == null || request.getId() == null || request.getId() < 0L) {
            log.error("Get user feedback detail error,feedback id - [{}].", (Object)request.getId());
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        UserFeedbackDto feedBack = this.userFeedbackMapper.selectById(request.getId());
        if (feedBack != null) {
            feedBack.setHandleRecord(this.userFeedbackHandleRecordMapper.listByFeedbackId(request.getId()));
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)feedBack);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<UserFeedbackHandleRecordDto> handle(@RequestBody AddUserFeedbackHandleRecordRequest request) {
        log.info("Handle user feedback, receive handle request - [{}]", (Object)request);
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        UserFeedbackApprovalStatusEnum approvalStatus = UserFeedbackApprovalStatusEnum.forCode((String)request.getApprovalStatus());
        if (StringUtils.isNotBlank((CharSequence)validateRes) || approvalStatus == null) {
            log.error("Handle user feedback error, param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        UserFeedback feedback = this.userFeedbackMapper.selectByPrimaryKey(request.getFeedbackId());
        if (feedback == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        Date now = new Date();
        UserFeedbackHandleRecordDto recordDto = new UserFeedbackHandleRecordDto();
        UserFeedbackHandleRecord record = new UserFeedbackHandleRecord();
        BeanUtils.copyProperties((Object)request, (Object)record);
        record.setCreateTime(now);
        this.userFeedbackHandleRecordMapper.insertSelective(record);
        BeanUtils.copyProperties((Object)record, (Object)recordDto);
        feedback.setApprovalStatus(approvalStatus.getCode());
        feedback.setUpdateBy(record.getCreateBy());
        feedback.setUpdateTime(record.getCreateTime());
        this.userFeedbackMapper.updateByPrimaryKey(feedback);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)recordDto);
    }
}

