/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.idworker.IdWrokerUtils;
import com.ella.user.api.RoleService;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.domain.Role;
import com.ella.user.domain.RoleMenuRelation;
import com.ella.user.dto.role.AddRoleRequest;
import com.ella.user.dto.role.EditRoleRequest;
import com.ella.user.dto.role.RoleDto;
import com.ella.user.mapper.MenuMapper;
import com.ella.user.mapper.RoleMapper;
import com.ella.user.mapper.RoleMenuRelationMapper;
import com.ella.user.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LogManager.getLogger(RoleServiceImpl.class);
    @Autowired
    RoleMapper roleMapper;
    @Autowired
    MenuMapper menuMapper;
    @Autowired
    RoleMenuRelationMapper roleMenuRelationMapper;

    public ResponseParams<List<RoleDto>> all() {
        ArrayList result = new ArrayList();
        List roles = this.roleMapper.selectAllNormal();
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            roles.forEach(r -> {
                RoleDto rd = new RoleDto();
                BeanUtils.copyProperties((Object)r, (Object)rd);
                result.add(rd);
            });
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, result);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> delete(@RequestParam(value="roleCode", required=true) String roleCode, @RequestParam(value="uid", required=true) String uid) {
        log.info("Delete role info code-[{}] by uid-[{}]", (Object)roleCode, (Object)uid);
        Role role = this.roleMapper.selectByCode(roleCode);
        if (role == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED);
        }
        int affectRow = this.roleMenuRelationMapper.deleteByRoleCode(roleCode);
        log.info("Delete role menu relation record num - [{}]", (Object)affectRow);
        affectRow = this.roleMapper.deleteByPrimaryKey(role.getId());
        log.info("Delete role record num - [{}]", (Object)affectRow);
        if (affectRow > 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR);
    }

    @EnableValidate
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> add(@RequestBody AddRoleRequest request) {
        Date now = new Date();
        String roleCode = String.format("RC%d", IdWrokerUtils.nextId());
        Role role = new Role();
        role.setRoleCode(roleCode);
        role.setRoleName(request.getRoleName());
        role.setStatus(DataStatusEnum.NORMAL.getCode());
        role.setCreateTime(now);
        int affectRow = this.roleMapper.insertSelective(role);
        if (affectRow < 1) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, (Object)Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getMenus())) {
            List rms = request.getMenus().stream().distinct().map(m -> new RoleMenuRelation(null, roleCode, m, DataStatusEnum.NORMAL.getCode(), now, now)).collect(Collectors.toList());
            this.roleMenuRelationMapper.batchInsert(rms);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }

    @EnableValidate
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> edit(@RequestBody EditRoleRequest request) {
        Date now = new Date();
        Role role = this.roleMapper.selectByCode(request.getRoleCode());
        if (role == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getRoleName())) {
            Role r = new Role();
            r.setId(role.getId());
            r.setRoleName(request.getRoleName());
            this.roleMapper.updateByPrimaryKeySelective(r);
        }
        this.roleMenuRelationMapper.deleteByRoleCode(role.getRoleCode());
        if (CollectionUtils.isNotEmpty((Collection)request.getMenus())) {
            List rms = request.getMenus().stream().distinct().map(m -> new RoleMenuRelation(null, role.getRoleCode(), m, DataStatusEnum.NORMAL.getCode(), now, now)).collect(Collectors.toList());
            this.roleMenuRelationMapper.batchInsert(rms);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
    }
}

