/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.alibaba.fastjson.JSON;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.api.NicknameCfgService;
import com.ella.user.api.enums.DataStatusEnum;
import com.ella.user.domain.NicknameCfg;
import com.ella.user.dto.AddNicknameCfgRequest;
import com.ella.user.dto.AddNicknameCfgUseNumRequest;
import com.ella.user.dto.ListNicknameCfgRequest;
import com.ella.user.dto.NicknameCfgDto;
import com.ella.user.dto.UpdateNicknameCfgRequest;
import com.ella.user.mapper.NicknameCfgMapper;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NicknameCfgServiceImpl
implements NicknameCfgService {
    private static final Logger log = LogManager.getLogger(NicknameCfgServiceImpl.class);
    @Autowired
    NicknameCfgMapper nicknameCfgMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<NicknameCfgDto> addNickname(@RequestBody AddNicknameCfgRequest request) {
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("Add nickname cfg input param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        NicknameCfg nickname = this.nicknameCfgMapper.selectOneByEName(request.getEName());
        if (nickname != null) {
            if (!DataStatusEnum.DELETE.getCode().equals(nickname.getStatus())) return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_EXISTED, null);
            this.nicknameCfgMapper.deleteByPrimaryKey(nickname.getId());
            nickname = new NicknameCfg();
        } else {
            nickname = new NicknameCfg();
        }
        Date now = new Date();
        BeanUtils.copyProperties((Object)request, (Object)nickname);
        nickname.setCreateBy(request.getCreateBy());
        nickname.setCreateTime(now);
        nickname.setUseNum(Long.valueOf(0L));
        nickname.setStatus(DataStatusEnum.NORMAL.getCode());
        int insertRes = this.nicknameCfgMapper.insertSelective(nickname);
        if (insertRes > 0) {
            log.info("Add nickname cfg [{}] success.", (Object)nickname.toString());
            nickname = this.nicknameCfgMapper.selectOneByEName(request.getEName());
            NicknameCfgDto nicknameCfgDto = new NicknameCfgDto();
            BeanUtils.copyProperties((Object)nickname, (Object)nicknameCfgDto);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)nicknameCfgDto);
        }
        log.error("Add nickname cfg [{}] error.", (Object)request.toString());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Boolean> addUseTimes(@RequestBody AddNicknameCfgUseNumRequest request) {
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("Add nickname cfg one use time input param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        if (this.nicknameCfgMapper.addOneUseNum(request.getEName()) > 0) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Boolean.TRUE);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, (Object)Boolean.FALSE);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<NicknameCfgDto> updateNicknameCfg(@RequestBody UpdateNicknameCfgRequest request) {
        String validateRes = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotBlank((CharSequence)validateRes)) {
            log.error("update nickname cfg input param [{}] error.--{}", (Object)request, (Object)validateRes);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        NicknameCfg nickname = this.nicknameCfgMapper.selectOneByEName(request.getEName());
        if (nickname == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED, null);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getStatus()) && !DataStatusEnum.contains((String)request.getStatus())) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        NicknameCfg unc = new NicknameCfg();
        Date now = new Date();
        BeanUtils.copyProperties((Object)request, (Object)unc);
        unc.setUpdateTime(now);
        unc.setId(nickname.getId());
        int affectRows = this.nicknameCfgMapper.updateByPrimaryKeySelective(unc);
        if (affectRows > 0) {
            log.info("update nickname cfg [{}] success.", (Object)nickname.toString());
            nickname = this.nicknameCfgMapper.selectByPrimaryKey(unc.getId());
            NicknameCfgDto nicknameCfgDto = new NicknameCfgDto();
            BeanUtils.copyProperties((Object)nickname, (Object)nicknameCfgDto);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)nicknameCfgDto);
        }
        log.error("update nickname cfg [{}] error.", (Object)request.toString());
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
    }

    public ResponseParams<PageInfo<NicknameCfgDto>> listNicknameCfg(@RequestBody ListNicknameCfgRequest request) {
        if (request == null) {
            request = new ListNicknameCfgRequest();
        }
        PageHelper.startPage((int)1, (int)7);
        request.setStatus("NORMAL");
        List cfgs = this.nicknameCfgMapper.selectSelective(request);
        PageInfo opages = new PageInfo(cfgs);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)opages);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ResponseParams<Map<String, String>> batchAddNickname(String contentsJson, String createBy) {
        log.info("batch add nickname cfg, receive data - [{}]", (Object)contentsJson);
        List contents = (List)JSON.parseObject((String)contentsJson, ArrayList.class);
        TreeMap<String, String> res = new TreeMap<String, String>();
        Date now = new Date();
        ArrayList cfgs = new ArrayList();
        contents.forEach(content -> {
            String ename = ((String)content.get(0)).trim();
            if (content.size() != 3) {
                res.put(ename, "\u6570\u636e\u5f02\u5e38");
            } else {
                NicknameCfg cfg = this.nicknameCfgMapper.selectOneByEName(ename);
                if (cfg != null && !DataStatusEnum.DELETE.getCode().equals(cfg.getStatus())) {
                    res.put(ename, "\u6570\u636e\u5df2\u5b58\u5728");
                } else {
                    if (cfg != null && DataStatusEnum.DELETE.getCode().equals(cfg.getStatus())) {
                        this.nicknameCfgMapper.deleteByPrimaryKey(cfg.getId());
                    }
                    cfg = new NicknameCfg();
                    cfg.seteName(ename);
                    cfg.setcName((String)content.get(1));
                    cfg.setGender("\u7537".equals(((String)content.get(2)).trim()) ? "MALE" : "FEMALE");
                    cfg.setCreateBy(createBy);
                    cfg.setCreateTime(now);
                    cfg.setUseNum(Long.valueOf(0L));
                    cfg.setStatus(DataStatusEnum.NORMAL.getCode());
                    if (res.containsKey(ename)) {
                        res.put(ename, (String)res.get(ename) + "-\u6570\u636e\u91cd\u590d");
                    } else {
                        cfgs.add(cfg);
                        res.put(ename, "\u6210\u529f");
                    }
                }
            }
        });
        int insertNums = 0;
        if (CollectionUtils.isNotEmpty(cfgs)) {
            insertNums = this.nicknameCfgMapper.insertBatch(cfgs);
        }
        res.put("sumInsertNum", String.valueOf(insertNums));
        if (contents.size() == insertNums) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, res);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PART_SUCCESS, res);
    }
}

