/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.api.MenuService;
import com.ella.user.domain.Menu;
import com.ella.user.domain.UserOts;
import com.ella.user.dto.menu.MenuDto;
import com.ella.user.mapper.MenuMapper;
import com.ella.user.mapper.UserOtsMapper;
import com.ella.user.utils.ResponseParamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MenuServiceImpl
implements MenuService {
    @Autowired
    MenuMapper menuMapper;
    @Autowired
    UserOtsMapper userOtsMapper;

    public ResponseParams<List<MenuDto>> getAllEnable() {
        List menus = this.menuMapper.selectAllEnable();
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.toMenuDtoTreeByMenus(menus));
    }

    public ResponseParams<List<MenuDto>> menusByRole(@RequestParam(value="roleCode", required=true) String roleCode) {
        List menus = this.menuMapper.selectByRoleCode(roleCode);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.toMenuDtoTreeByMenus(menus));
    }

    public ResponseParams<List<MenuDto>> menusByUid(@RequestParam(value="uid", required=true) String uid) {
        UserOts userOts = this.userOtsMapper.selectByUid(uid);
        if (userOts == null) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.DATA_NOT_EXISTED);
        }
        return this.menusByRole(userOts.getRoleCode());
    }

    public ResponseParams<List<MenuDto>> allByRole(String roleCode) {
        List result = null;
        List menus = this.menuMapper.selectAllEnable();
        List roleMenus = this.menuMapper.selectByRoleCode(roleCode);
        if (CollectionUtils.isEmpty((Collection)roleMenus)) {
            result = this.toMenuDtoTreeByMenus(menus);
        } else {
            List mds = this.menu2MenuDto(menus);
            Set checkedIds = roleMenus.stream().map(Menu::getId).collect(Collectors.toSet());
            mds.forEach(md -> {
                if (checkedIds.contains(md.getId())) {
                    md.setChecked(Integer.valueOf(1));
                }
            });
            result = this.toMenuDtoTreeByMenusDto(mds);
        }
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)this.toMenuDtoTreeByMenusDto(result));
    }

    private List<MenuDto> toMenuDtoTreeByMenus(List<Menu> menus) {
        return this.toMenuDtoTreeByMenusDto(this.menu2MenuDto(menus));
    }

    private List<MenuDto> menu2MenuDto(List<Menu> menus) {
        List<Object> result = menus == null ? new ArrayList<MenuDto>() : menus.stream().map(m -> {
            MenuDto md = new MenuDto();
            BeanUtils.copyProperties((Object)m, (Object)md);
            return md;
        }).collect(Collectors.toList());
        return result;
    }

    private List<MenuDto> toMenuDtoTreeByMenusDto(List<MenuDto> menus) {
        ArrayList<MenuDto> tree = null;
        if (CollectionUtils.isEmpty(menus)) {
            return tree;
        }
        HashMap l1 = new HashMap();
        menus.stream().filter(m -> m.getLevel() == 1).forEach(m -> l1.put(m.getId(), m));
        menus.forEach(m -> {
            if (m.getLevel() == 2) {
                MenuDto pm = (MenuDto)l1.get(m.getParentId());
                ArrayList<MenuDto> children = pm.getChildren();
                if (children == null) {
                    children = new ArrayList<MenuDto>();
                    pm.setChildren(children);
                }
                children.add((MenuDto)m);
            }
        });
        tree = new ArrayList<MenuDto>(l1.values());
        Collections.sort(tree);
        tree.forEach(t -> Collections.sort(t.getChildren()));
        return tree;
    }
}

