/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.service;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LevelService;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.request.GetLevelInfoRequest;
import com.ella.user.api.LexileLevelHistoryService;
import com.ella.user.dto.LexileLevelDto;
import com.ella.user.dto.LexileLevelHistoryDto;
import com.ella.user.dto.request.lexile.LexileEvaluationRequest;
import com.ella.user.dto.request.lexile.LexileLevelRequest;
import com.ella.user.service.transactional.LexileLevelHistoryTService;
import com.ella.user.utils.ResponseParamUtils;
import com.ella.user.utils.ValidationUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LexileLevelHistoryServiceImpl
implements LexileLevelHistoryService {
    private static final Logger log = LogManager.getLogger(LexileLevelHistoryServiceImpl.class);
    @Autowired
    LexileLevelHistoryTService service;
    @Autowired
    LevelService levelService;

    public ResponseParams<List<LexileLevelHistoryDto>> getLexileEvalHistoryList(@RequestBody LexileEvaluationRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u5217\u8868\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLexileEvalHistoryList param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        List result = this.service.getLexileEvalHistoryList(request);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)result);
    }

    public ResponseParams<LexileLevelHistoryDto> getLexileEvalHistoryDetail(@RequestBody LexileEvaluationRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u5f53\u524d\u84dd\u601d\u8bc4\u6d4b\u8be6\u60c5," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getLexileEvalHistoryDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LexileLevelHistoryDto lexile = this.service.getLexileEvalHistoryDetail(request);
        if (null == lexile) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SERVER_ERROR, null);
        }
        GetLevelInfoRequest levelReq = new GetLevelInfoRequest();
        levelReq.setLevelCode(lexile.getLevelCode());
        ResponseParams response = this.levelService.getLevelByCode(levelReq);
        LevelDto level = (LevelDto)response.getData();
        LexileLevelDto dto = new LexileLevelDto();
        BeanUtils.copyProperties((Object)level, (Object)dto);
        lexile.setLevelDto(dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)lexile);
    }

    public ResponseParams<LexileLevelHistoryDto> getOneLexileEvalHistoryDetail(@RequestBody LexileLevelRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u8be6\u60c5\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String checkResult = ValidationUtils.validateEntity((Object)request, (Class[])new Class[0]);
        if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
            log.info("getOneLexileEvalHistoryDetail param error,{}", (Object)checkResult);
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.PARAM_ERROR, null);
        }
        LexileLevelHistoryDto lexile = this.service.getOneLexileEvalHistoryDetail(request);
        if (null == lexile) {
            return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, null);
        }
        GetLevelInfoRequest levelReq = new GetLevelInfoRequest();
        levelReq.setLevelCode(lexile.getLevelCode());
        ResponseParams response = this.levelService.getLevelByCode(levelReq);
        LevelDto level = (LevelDto)response.getData();
        LexileLevelDto dto = new LexileLevelDto();
        BeanUtils.copyProperties((Object)level, (Object)dto);
        lexile.setLevelDto(dto);
        return ResponseParamUtils.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)lexile);
    }
}

