/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.configure;

import com.ella.user.configure.SecurityProperties;
import com.ella.user.configure.UserApprovalHandlerExt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.security.oauth2.provider.approval.TokenApprovalStore;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
@EnableAuthorizationServer
public class OAuth2Configuration
implements AuthorizationServerConfigurer {
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private SecurityProperties securityProperties;

    public void configure(AuthorizationServerSecurityConfigurer oauthServer) throws Exception {
        oauthServer.allowFormAuthenticationForClients();
        oauthServer.tokenKeyAccess("permitAll()");
        oauthServer.checkTokenAccess("isAuthenticated()");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.inMemory().withClient("ellaenglish_app").secret("1234X56").authorizedGrantTypes(new String[]{"password", "refresh_token"}).authorities(new String[]{"ROLE_CLIENT", "ROLE_TRUSTED_CLIENT"}).scopes(new String[]{"read", "write", "trust"}).accessTokenValiditySeconds(this.securityProperties.getAppTokenExpired()).and().withClient("ellaenglish_ots").secret("123X4X56").authorizedGrantTypes(new String[]{"password", "refresh_token"}).authorities(new String[]{"ROLE_CLIENT", "ROLE_TRUSTED_CLIENT"}).scopes(new String[]{"read", "write", "trust"}).accessTokenValiditySeconds(this.securityProperties.getOtsTokenExpired());
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.tokenStore(this.tokenStore()).authenticationManager(this.authenticationManager);
    }

    @Bean
    public TokenStore tokenStore() {
        return new RedisTokenStore(this.redisTemplate.getConnectionFactory());
    }

    @Bean
    public ApprovalStore approvalStore(TokenStore tokenStore) throws Exception {
        TokenApprovalStore store = new TokenApprovalStore();
        store.setTokenStore(tokenStore);
        return store;
    }

    @Bean
    public UserApprovalHandler userApprovalHandler(ApprovalStore approvalStore, ClientDetailsService clientDetailsService) {
        UserApprovalHandlerExt handler = new UserApprovalHandlerExt();
        handler.setApprovalStore(approvalStore);
        handler.setRequestFactory((OAuth2RequestFactory)new DefaultOAuth2RequestFactory(clientDetailsService));
        handler.setClientDetailsService(clientDetailsService);
        handler.setUseApprovalStore(true);
        return handler;
    }
}

