/*
 * Decompiled with CFR 0.152.
 */
package com.ella.user.utils;

import com.ella.user.auth.dto.MyUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Component;

@Component
public final class ContextUtils {
    private static Logger logger = LoggerFactory.getLogger(ContextUtils.class);
    private static OAuth2ClientContext staticOAuth2ClientContext;
    private static TokenStore staticTokenStore;

    public static void setStaticOAuth2ClientContext(OAuth2ClientContext staticOAuth2ClientContext) {
        ContextUtils.staticOAuth2ClientContext = staticOAuth2ClientContext;
    }

    public static void setStaticTokenStore(TokenStore staticTokenStore) {
        ContextUtils.staticTokenStore = staticTokenStore;
    }

    public static String getToken() {
        String token = null;
        OAuth2AccessToken accessToken = staticOAuth2ClientContext.getAccessToken();
        if (accessToken != null) {
            token = accessToken.getValue();
        }
        return token;
    }

    public static String getUid() {
        MyUserDetails userDetails = ContextUtils.getSession();
        return userDetails == null ? null : userDetails.getUid();
    }

    public static MyUserDetails getSession() {
        OAuth2Authentication authentication = staticTokenStore.readAuthentication(ContextUtils.getToken());
        if (authentication != null) {
            MyUserDetails user = (MyUserDetails)((Object)authentication.getPrincipal());
            return user;
        }
        logger.warn("staticTokenStore.readAuthentication(getToken()) \u8fd4\u56de\u4e86null");
        return null;
    }

    public static String getMobile() {
        MyUserDetails userDetails = ContextUtils.getSession();
        return userDetails == null ? null : userDetails.getMobile();
    }

    public static String getName() {
        MyUserDetails userDetails = ContextUtils.getSession();
        return userDetails == null ? null : userDetails.getName().split("#")[0];
    }

    public static String getFullName() {
        MyUserDetails userDetails = ContextUtils.getSession();
        return userDetails == null ? "" : userDetails.getName();
    }
}

