/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class PoiUtil {
    private static final Logger log = LogManager.getLogger(PoiUtil.class);
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";

    public static ArrayList<ArrayList<String>> readExcel(MultipartFile file) throws IOException {
        PoiUtil.checkFile((MultipartFile)file);
        Workbook workbook = PoiUtil.getWorkBook((MultipartFile)file);
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) continue;
                int firstRowNum = sheet.getFirstRowNum();
                int lastRowNum = sheet.getLastRowNum();
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
                    Row row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int firstCellNum = row.getFirstCellNum();
                    int lastCellNum = row.getPhysicalNumberOfCells();
                    ArrayList<String> cells = new ArrayList<String>();
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                        Cell cell = row.getCell(cellNum);
                        cells.add(PoiUtil.getCellValue((Cell)cell));
                    }
                    list.add(cells);
                }
            }
            workbook.close();
        }
        return list;
    }

    public static void checkFile(MultipartFile file) throws IOException {
        if (null == file) {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        String fileName = file.getOriginalFilename();
        if (!fileName.endsWith("xls") && !fileName.endsWith("xlsx")) {
            log.error(fileName + "\u4e0d\u662fexcel\u6587\u4ef6");
            throw new IOException(fileName + "\u4e0d\u662fexcel\u6587\u4ef6");
        }
    }

    public static Workbook getWorkBook(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        HSSFWorkbook workbook = null;
        try {
            InputStream is = file.getInputStream();
            if (fileName.endsWith("xls")) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith("xlsx")) {
                workbook = new XSSFWorkbook(is);
            }
        }
        catch (IOException e) {
            log.info(e.getMessage());
        }
        return workbook;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        if (cell.getCellTypeEnum().equals((Object)CellType.NUMERIC)) {
            cell.setCellType(CellType.STRING);
        }
        cellValue = CellType.NUMERIC.equals((Object)cell.getCellTypeEnum()) ? String.valueOf(cell.getNumericCellValue()) : (CellType.STRING.equals((Object)cell.getCellTypeEnum()) ? String.valueOf(cell.getStringCellValue()) : (CellType.BOOLEAN.equals((Object)cell.getCellTypeEnum()) ? String.valueOf(cell.getBooleanCellValue()) : (CellType.FORMULA.equals((Object)cell.getCellTypeEnum()) ? String.valueOf(cell.getCellFormula()) : (CellType.BLANK.equals((Object)cell.getCellTypeEnum()) ? "" : (CellType.ERROR.equals((Object)cell.getCellTypeEnum()) ? "\u975e\u6cd5\u5b57\u7b26" : "\u672a\u77e5\u7c7b\u578b")))));
        return cellValue;
    }

    public static XSSFWorkbook createExcel(List<List<String>> contents) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("sheet1");
        for (int i = 0; i < contents.size(); ++i) {
            List<String> rowContent = contents.get(i);
            XSSFRow row = sheet.createRow(i);
            for (int j = 0; j < rowContent.size(); ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellValue(rowContent.get(j));
            }
        }
        return wb;
    }
}

