/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.util;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.UUIDUtil;
import com.ella.rest.configuration.oss.AliOss;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/en/oss/"})
@Api(description="\u6587\u4ef6\u4e0a\u4f20")
public class OssRest {
    private static final Logger log = LogManager.getLogger(OssRest.class);
    @Autowired
    private AliOss aliOss;
    private static String filePath = "ella-english/";

    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20", response=String.class)
    @RequestMapping(value={"/upload/v1"}, method={RequestMethod.POST})
    public ResponseEntity upload(@RequestParam(value="file", required=false) MultipartFile file) {
        InputStream inputStream = null;
        try {
            String filename = file.getOriginalFilename();
            inputStream = file.getInputStream();
            long size = file.getSize();
            String url = this.aliOss.uploadObject2OSS(inputStream, UUIDUtil.uuid() + filename.substring(filename.lastIndexOf(".")), size, filePath + filename.substring(filename.lastIndexOf(".") + 1) + "/");
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f-----> {}", (Object)url);
            ResponseParams tResponseParams = new ResponseParams(CommonRetCode.SUCCESS.getCode(), CommonRetCode.SUCCESS.getMsg(), (Object)url);
            return RestResponseUtils.jointRestResponse((ResponseParams)tResponseParams);
        }
        catch (IOException e) {
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25-----> {}", (Object)e.getMessage());
            ResponseParams tResponseParams = new ResponseParams(CommonRetCode.SERVER_ERROR.getCode(), e.getMessage(), null);
            return RestResponseUtils.jointRestResponse((ResponseParams)tResponseParams);
        }
    }
}

