/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.UserReviewService;
import com.ella.user.dto.AddUserReviewRequest;
import com.ella.user.dto.ApplistUserReviewDto;
import com.ella.user.dto.ApplistUserReviewRequest;
import com.ella.user.dto.ListUserReviewRequest;
import com.ella.user.dto.UpdateUserReviewRequest;
import com.ella.user.dto.UserReviewDto;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user/review"})
@Api(description="\u7528\u6237\u8bc4\u8bba")
public class UserReviewRest {
    private static final Logger log = LogManager.getLogger(UserReviewRest.class);
    @Autowired
    UserReviewService userReviewService;

    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u8bc4\u8bba", notes="APP-\u6dfb\u52a0\u7528\u6237\u8bc4\u8bba-\u97e9\u8302\u4e30")
    @RequestMapping(path={"/add/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> addUserReview(@RequestBody AddUserReviewRequest request, HttpServletRequest request1) throws Exception {
        log.info("add user review [{}] ...", (Object)request);
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.userReviewService.addUserReview(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91\u7528\u6237\u8bc4\u8bba", notes="\u8fd0\u8425\u5de5\u5177-\u6dfb\u52a0\u7528\u6237\u8bc4\u8bba-\u97e9\u8302\u4e30", response=UserReviewDto.class)
    @RequestMapping(path={"/update/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateUserReview(@RequestBody UpdateUserReviewRequest request) {
        log.info("update user review [{}] ...", (Object)request);
        request.setUpdateBy(ContextUtils.getUid());
        ResponseParams result = this.userReviewService.updateUserReview(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7528\u6237\u8bc4\u8bba\u5217\u8868", notes="\u8fd0\u8425\u5de5\u5177-\u5206\u9875\u67e5\u8be2\u7528\u6237\u8bc4\u8bba-\u97e9\u8302\u4e30", response=UserReviewDto.class)
    @RequestMapping(path={"/list/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> listUserReview(@RequestBody ListUserReviewRequest request) {
        log.info("list user reviewes [{}] ...", (Object)request);
        if ("CURRENT".equals(request.getUserId())) {
            request.setUserId(ContextUtils.getUid());
        }
        if ("CURRENT".equals(request.getCreateBy())) {
            request.setUpdateBy(ContextUtils.getUid());
        }
        ResponseParams result = this.userReviewService.listUserReview(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP\u7528\u6237\u8bc4\u8bba\u5217\u8868", notes="APP\u7528\u6237\u8bc4\u8bba\u5217\u8868-zln", response=ApplistUserReviewDto.class)
    @RequestMapping(value={"/app/list/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> applistUserReview(@RequestBody ApplistUserReviewRequest request) {
        log.info("app/list user reviewes [{}] ...", (Object)request);
        ResponseParams result = this.userReviewService.applistUserReview(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

