/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.order.api.OrderService;
import com.ella.order.dto.order.UserOrderSummaryDto;
import com.ella.resource.api.LevelService;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.auth.AccountService;
import com.ella.user.api.learn.DictionaryService;
import com.ella.user.dto.AccountDto;
import com.ella.user.dto.LearnReportDetailDto;
import com.ella.user.dto.LearnReportDto;
import com.ella.user.dto.UserCourseDto;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.WordFollowRecordListDto;
import com.ella.user.dto.WordQueryRecordListDto;
import com.ella.user.dto.dictionary.DictionaryDto;
import com.ella.user.dto.request.dictionary.QueryWordInCourseRequest;
import com.ella.user.dto.request.dictionary.QueryWordRequest;
import com.ella.user.dto.request.userinfo.AreaRequest;
import com.ella.user.dto.request.userinfo.FindUserByIdRequest;
import com.ella.user.dto.request.userinfo.GetLearnReportRequest;
import com.ella.user.dto.request.userinfo.GetReportDetailRequest;
import com.ella.user.dto.request.userinfo.ListUserInfoRequest;
import com.ella.user.dto.request.userinfo.ReportWordRequest;
import com.ella.user.dto.request.userinfo.UpdateUserInfoRequest;
import com.ella.user.dto.user.UserDetailDto;
import com.ella.user.dto.user.UserListDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user/info"})
@Api(description="\u7528\u6237\u4fe1\u606f\u7ba1\u7406")
public class UserInfoRest {
    private static final Logger log = LogManager.getLogger(UserInfoRest.class);
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    DictionaryService dictionaryService;
    @Autowired
    OrderService orderService;
    @Autowired
    AccountService enAccountService;
    @Autowired
    private LevelService levelService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f-app", notes="app-\u83b7\u53d6\u7528\u6237\u4fe1\u606f-zhaojinliang", response=UserInfoDto.class)
    @RequestMapping(path={"/getUserInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getUserInfo(@RequestBody FindUserByIdRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String uid = request.getUid();
        request.setUid(uid);
        ResponseParams result = this.userInfoService.getUserInfoById(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f-app", notes="app-\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f-chenshuai", response=AccountDto.class)
    @RequestMapping(path={"/getUserAccountInfo/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> getUserAccountInfo(HttpServletRequest request) throws IOException {
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        log.info("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f,{}", (Object)uid);
        ResponseParams result = this.userInfoService.getUserAccountInfo(uid);
        log.info("\u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f,result:{}", (Object)uid);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91\u7528\u6237\u4fe1\u606f-app", notes="app_\u7f16\u8f91\u7528\u6237\u4fe1\u606f-zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"/updateUserInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateUserInfo(@RequestBody UpdateUserInfoRequest request) {
        log.info("\u7f16\u8f91\u7528\u6237\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String uid = request.getUid();
        request.setUid(uid);
        ResponseParams result = this.userInfoService.updateUser(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5b66\u4e60\u62a5\u544a\u4fe1\u606f-app", notes="app_\u83b7\u53d6\u7528\u6237\u5b66\u4e60\u62a5\u544a\u4fe1\u606f-zhaojinliang", response=LearnReportDto.class)
    @RequestMapping(path={"/getLearnReport/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLearnReport(@RequestBody GetLearnReportRequest request) {
        log.info("\u83b7\u53d6\u7528\u6237\u5b66\u4e60\u62a5\u544a\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        String uid = request.getUid();
        request.setUid(uid);
        ResponseParams result = this.userInfoService.getLearnReport(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5730\u533a\u5217\u8868\u4fe1\u606f-app", notes="app_\u83b7\u53d6\u5730\u533a\u5217\u8868\u4fe1\u606f-zhaojinliang", response=Map.class)
    @RequestMapping(path={"/getAreaInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getAreaInfo(@RequestBody AreaRequest request) {
        log.info("\u83b7\u53d6\u83b7\u53d6\u5730\u533a\u5217\u8868\u4fe1\u606f," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.userInfoService.getAreaInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u8be6\u60c5\u548c\u4f53\u9a8c\u7ea7\u5b66\u4e60\u8be6\u60c5-app", notes="app_\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u8be6\u60c5\u548c\u4f53\u9a8c\u7ea7\u5b66\u4e60\u8be6\u60c5-zhaojinliang", response=LearnReportDetailDto.class)
    @RequestMapping(path={"/getLearnReportMainDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLearnReportMainDetail(@RequestBody GetReportDetailRequest request) {
        log.info("\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u8be6\u60c5\u548c\u4f53\u9a8c\u7ea7\u5b66\u4e60\u8be6\u60c5," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.userInfoService.getLearnReportMainDetail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b66\u4e60\u62a5\u544aLV\u7ea7\u5b66\u4e60\u8be6\u60c5-app", notes="app_\u83b7\u53d6\u5b66\u4e60\u62a5\u544aLV\u7ea7\u5b66\u4e60\u8be6\u60c5-zhaojinliang", response=UserCourseDto.class)
    @RequestMapping(path={"/getLearnReportLVDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLearnReportLVDetail(@RequestBody GetReportDetailRequest request) {
        log.info("\u83b7\u53d6\u5b66\u4e60\u62a5\u544aLV\u7ea7\u5b66\u4e60\u8be6\u60c5," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.userInfoService.getLearnReportLVDetail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u8ddf\u8bfb\u8be6\u60c5-app", notes="app_\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u8ddf\u8bfb\u8be6\u60c5-zhaojinliang", response=WordFollowRecordListDto.class)
    @RequestMapping(path={"/getLearnReportFollowDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLearnReportFollowDetail(@RequestBody ReportWordRequest request) {
        log.info("\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u8ddf\u8bfb\u8be6\u60c5," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.userInfoService.getLearnReportFollowDetail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u67e5\u8be2\u8be6\u60c5-app", notes="app_\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u67e5\u8be2\u8be6\u60c5-zhaojinliang", response=WordQueryRecordListDto.class)
    @RequestMapping(path={"/getLearnReportQueryDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLearnReportQueryDetail(@RequestBody ReportWordRequest request) {
        log.info("\u83b7\u53d6\u5b66\u4e60\u62a5\u544a\u7ea7\u522b\u5185\u67e5\u8be2\u8be6\u60c5," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.userInfoService.getLearnReportQueryDetail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u5355\u8bcd-APP", notes="APP-\u67e5\u5355\u8bcd-chenshuai", response=DictionaryDto.class)
    @RequestMapping(path={"/queryWord/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> queryWord(@RequestBody QueryWordRequest request, HttpServletRequest request1) throws Exception {
        log.info("queryWord req:{}", (Object)JSONObject.toJSONString((Object)request));
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.dictionaryService.queryWord(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8bfe\u5802\u6a21\u5f0f\u67e5\u5355\u8bcd\u53ca\u8ddf\u8bfb\u4e13\u7528\u63a5\u53e3-APP", notes="APP-\u8bfe\u5802\u6a21\u5f0f\u67e5\u5355\u8bcd\u53ca\u8ddf\u8bfb\u4e13\u7528\u63a5\u53e3-chenshuai", response=DictionaryDto.class)
    @RequestMapping(path={"/queryWordInCourse/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> queryWordInCourse(@RequestBody QueryWordInCourseRequest request, HttpServletRequest request1) throws IOException {
        log.info("queryWordInCourse req:{}", (Object)JSONObject.toJSONString((Object)request));
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request1);
        request.setUid(uid);
        ResponseParams result = this.dictionaryService.queryWordAndUserVoiceInCourse(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7528\u6237\u5217\u8868-\u8fd0\u8425\u5de5\u5177", notes="\u67e5\u8be2APP\u7528\u6237\u5217\u8868-\u97e9\u8302\u4e30", response=UserListDto.class)
    @RequestMapping(path={"/list/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> list(@RequestBody ListUserInfoRequest request) {
        log.info("\u67e5\u8be2APP\u7528\u6237\u5217\u8868\u8bf7\u6c42-[{}]", (Object)request);
        ResponseParams result = this.userInfoService.listUserInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7528\u6237\u8be6\u60c5-\u8fd0\u8425\u5de5\u5177", notes="\u67e5\u8be2APP\u7528\u6237\u8be6\u60c5-\u97e9\u8302\u4e30", response=UserDetailDto.class)
    @RequestMapping(path={"/detail/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> detail(@RequestParam(value="uid", required=true) String uid) {
        log.info("\u67e5\u8be2APP\u7528\u6237\u8be6\u60c5\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)uid)) {
            return RestResponseUtils.jointRestResponse((ResponseParams)new ResponseParams(CommonRetCode.SESSION_INVALID));
        }
        ResponseParams result = this.userInfoService.detail(uid);
        if (CommonRetCode.SUCCESS.equalTo(result.getCode())) {
            UserDetailDto detail = (UserDetailDto)result.getData();
            ResponseParams userOrderSummary = this.orderService.getUserOrderSummary(uid);
            if (CommonRetCode.SUCCESS.equalTo(userOrderSummary.getCode())) {
                UserOrderSummaryDto orderSummary = (UserOrderSummaryDto)userOrderSummary.getData();
                detail.setSumCost(orderSummary.getSumCost());
                detail.setSumRecharge(orderSummary.getSumRecharge());
            }
            ResponseParams latestOrderGoodsName = this.orderService.getUserLatestOrderGoodsName(uid);
            if (CommonRetCode.SUCCESS.equalTo(userOrderSummary.getCode())) {
                detail.setLatestOrderGoodsName((String)latestOrderGoodsName.getData());
            }
        }
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8d26\u6237\u6982\u8981-\u8fd0\u8425\u5de5\u5177", notes="\u67e5\u8be2APP\u7528\u6237\u8d26\u6237\u6982\u8981\uff08\u7d2f\u8ba1\u5145\u503c\u3001\u6d88\u8d39\uff09-\u97e9\u8302\u4e30", response=UserOrderSummaryDto.class)
    @RequestMapping(path={"/account-summary/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> accountSummary(@RequestParam(value="uid", required=true) String uid) {
        ResponseParams userOrderSummary = this.orderService.getUserOrderSummary(uid);
        return RestResponseUtils.jointRestResponse((ResponseParams)userOrderSummary);
    }
}

