/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.alibaba.fastjson.JSON;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.rest.util.PoiUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.NicknameCfgService;
import com.ella.user.dto.AddNicknameCfgRequest;
import com.ella.user.dto.AddNicknameCfgUseNumRequest;
import com.ella.user.dto.ListNicknameCfgRequest;
import com.ella.user.dto.NicknameCfgDto;
import com.ella.user.dto.UpdateNicknameCfgRequest;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/en/user/nickname-cfg"})
@Api(description="\u7528\u6237\u4e2d\u82f1\u6587\u6635\u79f0\u914d\u7f6e\u64cd\u4f5c\u76f8\u5173\u63a5\u53e3")
public class NicknameCfgRest {
    private static final Logger log = LogManager.getLogger(NicknameCfgRest.class);
    @Autowired
    private NicknameCfgService nicknameCfgService;

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u9879\u6635\u79f0\u914d\u7f6e", notes="\u8fd0\u8425\u5de5\u5177-\u6dfb\u52a0\u7528\u6237\u6635\u79f0\u4fe1\u606f\u63a5\u53e3-\u97e9\u8302\u4e30", response=NicknameCfgDto.class)
    @RequestMapping(path={"/add/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> addNicknameCfg(@RequestBody AddNicknameCfgRequest request) {
        log.info("Add nickname [{}] ...", (Object)request);
        request.setCreateBy(ContextUtils.getUid());
        ResponseParams result = this.nicknameCfgService.addNickname(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6635\u79f0\u914d\u7f6e", notes="\u8fd0\u8425\u5de5\u5177-\u6279\u91cf\u6dfb\u52a0\u6635\u79f0\u914d\u7f6e-\u97e9\u8302\u4e30", response=Map.class)
    @RequestMapping(path={"/batch-add/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> batchAddNickname(@RequestParam(value="file", required=true) MultipartFile file) {
        log.info("batch add nickname cfg file info [{}]", (Object)file.getOriginalFilename());
        ArrayList contents = null;
        ResponseParams result = null;
        try {
            contents = PoiUtil.readExcel((MultipartFile)file);
            log.info("batch add nickname cfg, read file content [{}]", (Object)contents);
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u6635\u79f0\uff0c\u6587\u4ef6\u89e3\u6790\u9519\u8bef-[{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)contents)) {
            result = new ResponseParams(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg(), null);
        } else {
            String contentsJson = JSON.toJSONString((Object)contents);
            result = this.nicknameCfgService.batchAddNickname(contentsJson, ContextUtils.getUid());
        }
        return RestResponseUtils.jointRestResponse((ResponseParams)result, (boolean)true);
    }

    @ApiOperation(value="\u589e\u52a0\u6635\u79f0\u914d\u7f6e\u4e00\u6b21\u4f7f\u7528\u8bb0\u5f55", notes="APP-\u589e\u52a0\u4e00\u6b21\u6635\u79f0\u914d\u7f6e\u4f7f\u7528\u6b21\u6570-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/add-1-use-time/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> addOneUseTime(@RequestBody AddNicknameCfgUseNumRequest request) {
        log.info("Add [{}] one use time...", (Object)request);
        ResponseParams result = this.nicknameCfgService.addUseTimes(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u66f4\u65b0\u4e00\u9879\u6635\u79f0\u914d\u7f6e", notes="\u8fd0\u8425\u5de5\u5177-\u66f4\u65b0\u6635\u79f0\u914d\u7f6e\u63a5\u53e3-\u97e9\u8302\u4e30", response=NicknameCfgDto.class)
    @RequestMapping(path={"/update/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateNicknameCfg(@RequestBody UpdateNicknameCfgRequest request) {
        log.info("updateNicknameCfg [{}] ...", (Object)request);
        request.setUpdateBy(ContextUtils.getUid());
        ResponseParams result = this.nicknameCfgService.updateNicknameCfg(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6635\u79f0\u914d\u7f6e\u5217\u8868", notes="\u8fd0\u8425\u5de5\u5177/APP-\u5206\u9875\u67e5\u8be2\u6635\u79f0\u914d\u7f6e\u5217\u8868-\u97e9\u8302\u4e30", response=NicknameCfgDto.class)
    @RequestMapping(path={"/list/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> listNicknameCfg(@RequestBody ListNicknameCfgRequest request) {
        log.info("list nickname cfgs [{}] ...", (Object)request);
        ResponseParams result = this.nicknameCfgService.listNicknameCfg(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u6635\u79f0Excel\u6a21\u677f", notes="\u8fd0\u8425\u5de5\u5177-\u6279\u91cf\u5bfc\u5165\u6635\u79f0Excel\u6a21\u677f-\u97e9\u8302\u4e30")
    @RequestMapping(path={"/batch-add-templete/v1"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public void batchAddTemplete(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<List<String>> tempContent = new ArrayList<List<String>>();
        tempContent.add(Arrays.asList("\u82f1\u6587\u540d", "\u4e2d\u6587\u540d", "\u6027\u522b(\u7537/\u5973)"));
        tempContent.add(Arrays.asList("Anna", "\u5b89\u5a1c", "\u5973"));
        tempContent.add(Arrays.asList("James", "\u8a79\u59c6\u65af", "\u7537"));
        XSSFWorkbook wb = PoiUtil.createExcel(tempContent);
        String fileName = "batch-add-nickname-templete.xlsx";
        response.setContentType("application/octet-stream;charset=ISO8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        try {
            ServletOutputStream os = response.getOutputStream();
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.error("Get batch add templete error - [{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

