/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.cache.DistributedCache;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import com.ella.frame.common.response.ResponseParams;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.auth.SecurityService;
import com.ella.user.dto.user.Session;
import com.ella.user.dto.user.UserLoginRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user/"})
@Api(description="\u7528\u6237\u767b\u9646\u76f8\u5173\u63a5\u53e3")
public class LoginRest {
    private static final Logger log = LogManager.getLogger(LoginRest.class);
    @Autowired
    DistributedCache cache;
    @Autowired
    private SecurityService securityService;

    @ApiOperation(value="\u7528\u6237\u767b\u9646\u63a5\u53e3", notes="\u7528\u6237\u767b\u9646\u63a5\u53e3", response=Session.class)
    @RequestMapping(path={"login/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> login(@RequestBody UserLoginRequest request, HttpServletRequest httpRequest) {
        log.info("\u767b\u5f55\u5f00\u59cb: {}", (Object)JSONObject.toJSONString((Object)request));
        try {
            log.info("authorization:" + httpRequest.getHeader("Authorization"));
            ResponseParams result = this.securityService.login(request);
            return RestResponseUtils.jointRestResponse((ResponseParams)result);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            ResponseEntity response = new ResponseEntity((Object)new ErrorMessage(CommonRetCode.SERVER_ERROR.getCode(), CommonRetCode.SERVER_ERROR.getMsg()), HttpStatus.INTERNAL_SERVER_ERROR);
            return response;
        }
    }
}

