/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.alibaba.fastjson.JSON;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.WordWallService;
import com.ella.resource.dto.request.AddWordReq;
import com.ella.resource.dto.request.SelectWordReq;
import com.ella.resource.dto.request.app.PutUserWordWallRequest;
import com.ella.rest.util.PoiUtil;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/en/wordWall/"})
@Api(description="\u5355\u8bcd\u5899")
public class WordWallRest {
    private static final Logger log = LogManager.getLogger(WordWallRest.class);
    @Autowired
    private WordWallService wordWallService;

    @ApiOperation(value="\u5355\u8bcd\u5899\u67e5\u8be2", notes="\u5355\u8bcd\u5899\u67e5\u8be2--zln")
    @RequestMapping(value={"selectWord/V1"}, method={RequestMethod.POST})
    public ResponseEntity selectWord(@RequestBody SelectWordReq req, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)req);
        ResponseParams responseParams = this.wordWallService.selectWord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams, (boolean)true);
    }

    @ApiOperation(value="\u5355\u8bcd\u5bfc\u51faexcle--OTS", notes="\u5355\u8bcd\u5bfc\u51faexcle--zln")
    @RequestMapping(value={"expotExcle/v1"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public void expotExcle(HttpServletResponse response) throws IOException {
        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=classTemplate.xls");
        log.info("---------->\u5355\u8bcd\u5bfc\u51faexcle\u5f00\u59cb");
        ResponseParams listResponseParams = this.wordWallService.expotExcle();
        List data = (List)listResponseParams.getData();
        XSSFWorkbook excel = PoiUtil.createExcel((List)data);
        log.info("---------->\u5355\u8bcd\u5bfc\u51faexcle\u5b8c\u6210");
        excel.write((OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="\u5355\u8bcd\u624b\u52a8\u6dfb\u52a0--OTS", notes="\u5355\u8bcd\u624b\u52a8\u6dfb\u52a0--zln", response=Boolean.class)
    @RequestMapping(value={"addWord/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity addWord(@RequestBody AddWordReq req, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)req);
        ResponseParams responseParams = this.wordWallService.addWord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams, (boolean)true);
    }

    @ApiOperation(value="\u5355\u8bcd\u6279\u91cf\u6dfb\u52a0--OTS", notes="\u5355\u8bcd\u6279\u91cf\u6dfb\u52a0--zln", response=Boolean.class)
    @RequestMapping(value={"addBachWord/V1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity addBachWord(@RequestParam(value="file", required=true) MultipartFile file) {
        log.info("batch add nickname cfg file info [{}]", (Object)file.getOriginalFilename());
        ArrayList contents = null;
        try {
            contents = PoiUtil.readExcel((MultipartFile)file);
            log.info("batch add Word , read file content [{}]", (Object)contents);
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u5355\u8bcd\uff0c\u6587\u4ef6\u89e3\u6790\u9519\u8bef-[{}]", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)contents)) {
            return new ResponseEntity((Object)new ErrorMessage(CommonRetCode.PARAM_ERROR.getCode(), CommonRetCode.PARAM_ERROR.getMsg()), HttpStatus.BAD_REQUEST);
        }
        String contentsJson = JSON.toJSONString((Object)contents);
        ResponseParams stringResponseParams = this.wordWallService.addBachWordStr(contentsJson);
        return RestResponseUtils.jointRestResponse((ResponseParams)stringResponseParams, (boolean)true);
    }

    @ApiOperation(value="\u6536\u85cf\u5355\u8bcd\u5899APP--LiBin", notes="\u6536\u85cf\u5355\u8bcd\u5899\u63a5\u53e3APP--LiBin", response=Boolean.class)
    @RequestMapping(value={"putUserWordWall/v1"}, method={RequestMethod.POST})
    public ResponseEntity putUserWordWall(@RequestBody PutUserWordWallRequest request, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        return RestResponseUtils.jointRestResponse((ResponseParams)this.wordWallService.putUserWordWall(request));
    }
}

