/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.ResQuestionService;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.ResQuestionListDto;
import com.ella.resource.dto.request.question.DeleteResQuestionRequest;
import com.ella.resource.dto.request.question.EditResQuestionRequest;
import com.ella.resource.dto.request.question.QueryResQuestionRequest;
import com.ella.resource.dto.request.question.QuestionsByOccupantTypeReq;
import com.ella.resource.dto.request.question.SaveResQuestionRequest;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u9898\u76ee\u76f8\u5173\u63a5\u53e3")
public class ResQuestionRest {
    private static final Logger log = LogManager.getLogger(ResQuestionRest.class);
    @Autowired
    ResQuestionService resQuestionService;

    @ApiOperation(value="\u6dfb\u52a0\u9898\u76ee\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u6dfb\u52a0\u9898\u76ee\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"saveResQuestion/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> saveResQuestion(@RequestBody SaveResQuestionRequest request) {
        log.info("\u6dfb\u52a0\u9898\u76ee," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.insertResQuestion(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91\u9898\u76ee\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u7f16\u8f91\u9898\u76ee\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"updateResQuestion/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateResQuestion(@RequestBody EditResQuestionRequest request) {
        log.info("\u7f16\u8f91\u9898\u76ee," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.updateResQuestion(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u9898\u76ee(\u5217\u8868/\u6761\u4ef6)\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u83b7\u53d6\u9898\u76ee(\u5217\u8868/\u6761\u4ef6)\u63a5\u53e3--zhaojinliang", response=ResQuestionListDto.class)
    @RequestMapping(path={"getAllResQuestion/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getAllResQuestion(@RequestBody QueryResQuestionRequest request) {
        log.info("\u83b7\u53d6\u9898\u76ee\u5217\u8868," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.getAllResQuestionInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6309id\u67e5\u8be2\u9898\u76ee\u8be6\u60c5\u63a5\u53e3--OTS", notes="\u6309ID\u67e5\u8be2\u9898\u76ee\u8be6\u60c5\u63a5\u53e3(\u70b9\u7f16\u8f91\u6309\u94ae)--zhaojinliang", response=ResQuestionDto.class)
    @RequestMapping(path={"getQuestionByQueryCon/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getQuestionByQueryConditon(@RequestBody DeleteResQuestionRequest request) {
        log.info("\u6839\u636eID\u67e5\u8be2\u9898\u76ee\u8be6\u60c5,\u6761\u4ef6\u4e3a\uff1a" + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.getQuestionById(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5220\u9664\u9898\u76ee\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u5220\u9664\u9898\u76ee\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"deleteResQuestion/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> deleteResQuestion(@RequestBody DeleteResQuestionRequest request) {
        log.info("\u5220\u9664\u6307\u5b9a\u9898\u76ee," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.deleteResQuestion(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u8fc7\u6ee4\u6389\u5360\u7528\u8005\u540e\u7684\u9898\u76ee\u5217\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u83b7\u53d6\u8fc7\u6ee4\u6389\u5360\u7528\u8005\u540e\u7684\u9898\u76ee\u5217\u8868\u63a5\u53e3--zhaojinliang", response=ResQuestionListDto.class)
    @RequestMapping(path={"getResQuestionByOccupant/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getResQuestionByOccupant(@RequestBody QuestionsByOccupantTypeReq request) {
        log.info("\u83b7\u53d6\u9898\u76ee\u5217\u8868," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.resQuestionService.getResQuestionByOccupant(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

