/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.PicBookService;
import com.ella.resource.dto.GetPicBookInfoDto;
import com.ella.resource.dto.PicBookStoreDto;
import com.ella.resource.dto.request.AddPicBookReq;
import com.ella.resource.dto.request.AddReadCountReq;
import com.ella.resource.dto.request.GetPicBookInfoReq;
import com.ella.resource.dto.request.PicBookListReq;
import com.ella.resource.dto.request.PicBookStoreReq;
import com.ella.resource.dto.request.ReadRecordReq;
import com.ella.rest.util.NetworkUtil;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/picBook/"})
@Api(description="\u7ed8\u672c")
public class PicBookRest {
    private static final Logger log = LogManager.getLogger(PicBookRest.class);
    @Autowired
    private PicBookService picBookService;

    @ApiOperation(value="OTS\u7b49\u7ea7\u5217\u8868\u6dfb\u52a0\u7ed8\u672c", notes="APP\u7ed8\u672c\u9605\u8bfb\u767e\u5206\u6bd4\u8bb0\u5f55--zln", response=Boolean.class)
    @RequestMapping(value={"v1/levelAddPicBook"}, method={RequestMethod.POST})
    public ResponseEntity levelAddPicBook(@RequestBody PicBookListReq req) {
        ResponseParams responseParams = this.picBookService.levelAddPicBook(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="APP\u7ed8\u672c\u9605\u8bfb\u767e\u5206\u6bd4\u8bb0\u5f55", notes="APP\u7ed8\u672c\u9605\u8bfb\u767e\u5206\u6bd4\u8bb0\u5f55--zln", response=Boolean.class)
    @RequestMapping(value={"v1/readRecord"}, method={RequestMethod.POST})
    public ResponseEntity readRecord(@RequestBody ReadRecordReq req, HttpServletRequest request) throws Exception {
        req.setReadIp(NetworkUtil.getIpAddress((HttpServletRequest)request));
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request, (Object)req);
        ResponseParams responseParams = this.picBookService.readRecord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u7ed8\u672c\u9605\u8bfb\u4eba\u6570+1", notes="\u7ed8\u672c\u9605\u8bfb\u4eba\u6570+1--zln", response=Boolean.class)
    @RequestMapping(value={"addReadCount/v1"}, method={RequestMethod.POST})
    public ResponseEntity addReadCount(@RequestBody AddReadCountReq req) {
        ResponseParams responseParams = this.picBookService.addReadCount(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="app\u6211\u7684\u7ed8\u672c\u8be6\u60c5\u9875", notes="app\u6211\u7684\u7ed8\u672c\u8be6\u60c5\u9875--zln", response=GetPicBookInfoDto.class)
    @RequestMapping(value={"getPicBookInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity getPicBookInfo(@RequestBody GetPicBookInfoReq req, HttpServletRequest request) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request, (Object)req);
        ResponseParams picBookInfo = this.picBookService.getPicBookInfo(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)picBookInfo);
    }

    @ApiOperation(value="app\u6211\u7684\u7ed8\u672c", notes="app\u6211\u7684\u7ed8\u672c--zln", response=PicBookStoreDto.class)
    @RequestMapping(value={"picBookStore/v1"}, method={RequestMethod.POST})
    public ResponseEntity picBookStore(@RequestBody PicBookStoreReq req, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)req);
        ResponseParams responseParams = this.picBookService.picBookStore(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u7ed8\u672c\u5217\u8868", notes="\u7ed8\u672c\u5217\u8868--zln", response=AddPicBookReq.class)
    @RequestMapping(value={"picBookList/v1"}, method={RequestMethod.POST})
    public ResponseEntity picBookList(@RequestBody PicBookListReq req) {
        ResponseParams responseParams = this.picBookService.picBookList(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u65b0\u589e\u7ed8\u672c", notes="\u65b0\u589e\u7ed8\u672c--zln", response=Boolean.class)
    @RequestMapping(value={"updatePicBook/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity updatePicBook(@RequestBody AddPicBookReq res) {
        ResponseParams responseParams = this.picBookService.updatePicBook(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u7ed8\u672c\u4fe1\u606f", notes="\u65b0\u589e\u7ed8\u672c--zln", response=AddPicBookReq.class)
    @RequestMapping(value={"getInfoById/v1"}, method={RequestMethod.GET})
    public ResponseEntity getInfoById(@RequestParam(value="id") String id) {
        ResponseParams infoById = this.picBookService.getInfoById(Integer.valueOf(id));
        return RestResponseUtils.jointRestResponse((ResponseParams)infoById);
    }
}

