/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.MapService;
import com.ella.resource.api.UserMapAndMissionSnapshotService;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.appdto.UserMapListDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.map.GetMapListRequest;
import com.ella.resource.dto.request.map.SaveMapRequest;
import com.ella.resource.dto.request.map.SetMapIcoRequest;
import com.ella.resource.dto.request.map.UpdateMapRequest;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u5730\u56fe\u76f8\u5173\u63a5\u53e3")
public class MapRest {
    private static final Logger log = LogManager.getLogger(MapRest.class);
    @Autowired
    private MapService mapService;
    @Autowired
    private UserMapAndMissionSnapshotService userMapAndMissionService;

    @ApiOperation(value="\u5730\u56fe\u5217\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u5730\u56fe\u5217\u8868\u63a5\u53e3--LiBin", response=MapDto.class)
    @RequestMapping(path={"getMapList/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMapList(@RequestBody GetMapListRequest request) {
        ResponseParams result = this.mapService.getMapList(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5730\u56fe\u8be6\u60c5\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u5730\u56fe\u8be6\u60c5\u63a5\u53e3--LiBin", response=MapDto.class)
    @RequestMapping(path={"getMapInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMapInfo(@RequestBody GetMapInfoRequest request) {
        ResponseParams result = this.mapService.getMapInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5730\u56fe\u65b0\u589e\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u65b0\u589e\u63a5\u53e3--LiBin", response=Integer.class)
    @RequestMapping(path={"saveMap/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> saveMap(@RequestBody SaveMapRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.mapService.saveMap(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5730\u56fe\u7f16\u8f91\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u7f16\u8f91\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"updateMap/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateMap(@RequestBody UpdateMapRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.mapService.updateMap(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5730\u56fe\u5220\u9664\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u5220\u9664\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"deleteMap/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> deleteMap(@RequestBody GetMapInfoRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.mapService.deleteMap(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5730\u56fe\u56fe\u6807--OTS", notes="\u8fd0\u8425\u5de5\u5177\u8bbe\u7f6e\u5730\u56fe\u56fe\u6807\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"setMapIco/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> setMapIco(@RequestBody SetMapIcoRequest request) {
        ResponseParams result = this.mapService.setMapIco(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5730\u56fe\u5e95\u90e8\u56fe\u7247--OTS", notes="\u8fd0\u8425\u5de5\u5177\u8bbe\u7f6e\u5730\u56fe\u5e95\u90e8\u56fe\u7247\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"setMapBottomUrl/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> setMapBottomUrl(@RequestBody SetMapIcoRequest request) {
        ResponseParams result = this.mapService.setMapBottomUrl(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6211\u7684\u5730\u56fe--APP", notes="APP\u6211\u7684\u5730\u56fe\u63a5\u53e3--LiBin", response=UserMapListDto.class)
    @RequestMapping(path={"selectUserMap/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> selectUserMap(@RequestBody(required=false) BaseRequest request, HttpServletRequest httpServletRequest) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)httpServletRequest, (Object)request);
        ResponseParams result = this.userMapAndMissionService.selectUserMap(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd4\u56de\u5bf9\u5e94\u7b49\u7ea7\u7684\u5730\u56fe\u5bf9\u5e94\u6700\u5927\u5e8f\u53f7--APP", notes="\u8fd4\u56de\u5bf9\u5e94\u7b49\u7ea7\u7684\u5730\u56fe\u5bf9\u5e94\u6700\u5927\u5e8f\u53f7", response=UserMapListDto.class)
    @RequestMapping(path={"selectMapAndOrder/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> selectMapAndOrder() {
        ResponseParams result = this.mapService.selectMapAndOrder();
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

