/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.dto.HeadParamDto;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.DateUtil;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.frame.common.util.LexileUtil;
import com.ella.resource.api.LevelService;
import com.ella.resource.api.LexileEvaluationService;
import com.ella.resource.api.LexileLevelHistoryService;
import com.ella.resource.api.MapService;
import com.ella.resource.api.MissionService;
import com.ella.resource.api.UserMapAndMissionSnapshotService;
import com.ella.resource.constants.LevelEnum;
import com.ella.resource.constants.LexileEvaluationStatusEnum;
import com.ella.resource.dto.GetLevelInfoResponse;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileLevelHistoryDto;
import com.ella.resource.dto.PrepareLexileEvaluationDto;
import com.ella.resource.dto.StartLexileEvaluationRequest;
import com.ella.resource.dto.appdto.GetInitiativeInfoResponse;
import com.ella.resource.dto.appdto.MapMissionDto;
import com.ella.resource.dto.request.lexile.LexileEvalutionHandOverRequest;
import com.ella.resource.dto.request.question.LexileAnswerResponse;
import com.ella.resource.dto.request.question.LexileEvaHistoryDetailDto;
import com.ella.rest.util.ConcurrentLockUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.UserInfoService;
import com.ella.user.api.account.UserAccountService;
import com.ella.user.dto.UserInfoDto;
import com.ella.user.dto.account.AccountDto;
import com.ella.user.dto.account.EventTypeEnum;
import com.ella.user.dto.account.ModifyUserStoneRequest;
import com.ella.user.dto.account.MoneyChangeTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u84dd\u601d\u8bc4\u6d4b")
@RequestMapping(value={"/en/lexile-test"})
public class LexileLevelRest {
    private static final Logger log = LogManager.getLogger(LexileLevelRest.class);
    @Autowired
    LexileLevelHistoryService lexileLevelHistoryService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    private UserMapAndMissionSnapshotService userMapAndMissionSnapshotService;
    @Autowired
    LexileEvaluationService lexileEvaluationService;
    @Autowired
    ConcurrentLockUtil ccl;
    @Autowired
    MissionService missionService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private MapService mapService;
    @Value(value="${lexile.promotion.failed.period}")
    int lexilePromotionFailedPeriod;
    @Autowired
    private LevelService levelService;

    @ApiOperation(value="\u84dd\u601d\u8bc4\u6d4b\u51c6\u5907--APP", notes="\u84dd\u601d\u8bc4\u6d4b\u51c6\u5907--\u97e9\u8302\u4e30", response=PrepareLexileEvaluationDto.class)
    @RequestMapping(value={"/prepare/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> prepare(@RequestParam(value="missionId", required=true) Long missionId, HttpServletRequest request) throws IOException {
        ResponseParams passedHistory;
        ResponseParams resultLlh;
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        ResponseParams result = null;
        UserInfoDto ud = null;
        ResponseParams userInfo = this.userInfoService.selectUserByUid(uid);
        if (!CommonRetCode.isSuccess((String)userInfo.getCode())) {
            result = new ResponseParams(CommonRetCode.UNAUTHORIZED.getCode(), CommonRetCode.UNAUTHORIZED.getMsg(), null);
            return RestResponseUtils.jointRestResponse((ResponseParams)result);
        }
        ud = (UserInfoDto)userInfo.getData();
        LexileEvaluationDto eva = null;
        String missionLevel = LevelEnum.LV0.getCode();
        MapMissionDto mapMissionDto = null;
        if (missionId > 0L) {
            mapMissionDto = (MapMissionDto)this.missionService.getLevelCodeById(missionId).getData();
            missionLevel = mapMissionDto.getLevelCode();
            if (StringUtils.isBlank((CharSequence)missionLevel)) {
                log.error("Mission [{}] has not matched lexile evaluation.", (Object)missionId);
                result = new ResponseParams(CommonRetCode.DATA_NOT_EXISTED.getCode(), "\u5173\u5361\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u84dd\u601d\u7b49\u7ea7\uff01", null);
                return RestResponseUtils.jointRestResponse((ResponseParams)result);
            }
            eva = this.getLevelCodeMatchLexilEvaluation(missionLevel);
        } else {
            eva = this.getUserMatchLexilEvaluation(ud);
        }
        if (eva == null) {
            log.error("User matched lexile evaluation not existed.", (Object)uid);
            result = new ResponseParams(CommonRetCode.DATA_NOT_EXISTED.getCode(), CommonRetCode.DATA_NOT_EXISTED.getMsg(), null);
            return RestResponseUtils.jointRestResponse((ResponseParams)result);
        }
        LevelEnum currLevel = LevelEnum.ofId((int)eva.getLevelId().intValue());
        ResponseParams questionNum = this.lexileEvaluationService.countEvaluationQuestiones(eva.getId());
        PrepareLexileEvaluationDto prepareDto = PrepareLexileEvaluationDto.builder().currentEvaluationQuestionNum(CommonRetCode.isSuccess((String)questionNum.getCode()) ? (Integer)questionNum.getData() : Integer.valueOf(0)).currentEvaluationId(eva.getId()).expectCostMinutes(eva.getExpectedTime()).stoneNum(eva.getStoneNum()).enableStart(Boolean.TRUE).unlocked(Boolean.TRUE).balance(BigDecimal.ZERO).iosBalance(BigDecimal.ZERO).stoneBalance(Integer.valueOf(0)).build();
        if (mapMissionDto != null) {
            prepareDto.setLevelOrder(mapMissionDto.getLevelOrder());
            prepareDto.setMissionIndex(mapMissionDto.getMissionIndex());
        }
        prepareDto.setLevelCode(missionLevel);
        if (eva.getStoneNum() > 0) {
            prepareDto.setUnlocked(Boolean.valueOf(this.checkLexileEvaluationHasUnlocked(uid, currLevel.getCode())));
        }
        if (CommonRetCode.isSuccess((String)(resultLlh = this.lexileLevelHistoryService.latestLexileHistory(uid)).getCode())) {
            LexileLevelHistoryDto history = (LexileLevelHistoryDto)resultLlh.getData();
            prepareDto.setLastEvaluationLevelCode(history.getLevelCode());
            prepareDto.setLastEvaluationTime(history.getCreateTime());
            if (LexileEvaluationStatusEnum.UNCOMPLETED.equalTo(history.getStatus()) || history.getLexileLevel().equals("")) {
                prepareDto.setLastEvaluationResult("\u672a\u5b8c\u6210");
            } else {
                prepareDto.setLastEvaluationResult(history.getLexileLevel());
            }
            prepareDto.setLastEvaluationStatus(history.getStatus());
            prepareDto.setLastEvaluationRecordId(Long.valueOf(history.getId().longValue()));
            prepareDto.setEnableStart(Boolean.valueOf(this.enableStartNewEvaluation(history)));
        }
        boolean hasPassed = false;
        if (LexileUtil.biggerThan((String)ud.getLevel(), (String)missionLevel) && CommonRetCode.isSuccess((String)(passedHistory = this.lexileLevelHistoryService.maxScoreHistoryByOriginLevelCode(missionLevel, uid)).getCode())) {
            hasPassed = true;
        }
        prepareDto.setIsPass(String.valueOf(false));
        prepareDto.setIsClickable(StringUtils.isBlank((CharSequence)ud.getLevel()) && missionId < 0L ? Boolean.TRUE : this.userMapAndMissionSnapshotService.missionClickable(uid, missionId, missionLevel, "up"));
        this.settleBalanceInfo(uid, prepareDto);
        if (mapMissionDto != null) {
            String mapId = this.mapService.getNextMapId(uid, mapMissionDto.getMapCode());
            prepareDto.setNextMapId(mapId);
        }
        result = new ResponseParams(CommonRetCode.SUCCESS.getCode(), CommonRetCode.SUCCESS.getMsg(), (Object)prepareDto);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    private void settleBalanceInfo(String uid, PrepareLexileEvaluationDto prepareDto) {
        AccountDto account = this.userAccountService.queryUserEllaCoin(uid);
        if (Objects.nonNull(account)) {
            prepareDto.setBalance(account.getBalance());
            prepareDto.setIosBalance(account.getIosBalance());
            prepareDto.setStoneBalance(account.getStoneNum());
        }
    }

    @ApiOperation(value="\u89e3\u9501\u84dd\u601d\u8bc4\u6d4b--APP", notes="\u89e3\u9501\u84dd\u601d\u8bc4\u6d4b--\u97e9\u8302\u4e30")
    @RequestMapping(value={"/unlock/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> unlock(@RequestParam(value="evaluationId", required=true) Long evaluationId, HttpServletRequest request) throws IOException {
        ResponseParams result = ResponseParams.buildSuccessResponse();
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)uid)) {
            result = ResponseParams.build((CommonRetCode)CommonRetCode.UNAUTHORIZED);
            return RestResponseUtils.jointRestResponse((ResponseParams)result);
        }
        ResponseParams evaResp = this.lexileEvaluationService.getEvaluationById(evaluationId);
        if (CommonRetCode.isSuccess((String)evaResp.getCode())) {
            ModifyUserStoneRequest req;
            ResponseParams res;
            LexileEvaluationDto eva = (LexileEvaluationDto)evaResp.getData();
            LevelEnum currLevel = LevelEnum.ofId((int)eva.getLevelId().intValue());
            Date now = new Date();
            if (eva.getStoneNum() > 0 && !this.checkLexileEvaluationHasUnlocked(uid, currLevel.getCode()) && !CommonRetCode.SUCCESS.equalTo((res = this.userAccountService.modifyUserStone(req = ModifyUserStoneRequest.builder().uid(uid).stoneNum(eva.getStoneNum()).timex(Long.valueOf(now.getTime())).relationId(LexileUtil.formartStoneOrderRelationId((String)currLevel.getCode())).opperType(MoneyChangeTypeEnum.MINUS).eventType(EventTypeEnum.LEXILE_TEST).description("\u80fd\u91cf\u77f3\u89e3\u9501\u84dd\u601d\u8bc4\u6d4b").build())).getCode())) {
                result = ResponseParams.build((String)res.getCode(), (String)res.getMessage());
            }
        }
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    private boolean checkLexileEvaluationHasUnlocked(String uid, String levelCode) {
        boolean res = false;
        ResponseParams checkRes = this.userAccountService.checkStoneHasConsumed(uid, EventTypeEnum.LEXILE_TEST, LexileUtil.formartStoneOrderRelationId((String)levelCode));
        if (CommonRetCode.isSuccess((String)checkRes.getCode())) {
            res = (Boolean)checkRes.getData();
        }
        return res;
    }

    private boolean enableStartNewEvaluation(LexileLevelHistoryDto history) {
        boolean res = true;
        if (LexileEvaluationStatusEnum.COMPLETED.equalTo(history.getStatus()) && !history.getPromotion().booleanValue()) {
            Date now = new Date();
            long diffDays = DateUtil.differentDays((Date)history.getCreateTime(), (Date)now);
            if (diffDays < (long)this.lexilePromotionFailedPeriod) {
                res = false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5f00\u59cb\u8bc4\u6d4b--APP", notes="\u5f00\u59cb\u8bc4\u6d4b--\u97e9\u8302\u4e30", response=LexileLevelHistoryDto.class)
    @RequestMapping(value={"/start/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> start(@RequestBody StartLexileEvaluationRequest request, HttpServletRequest httpServletRequest) throws IOException {
        ResponseParams result = null;
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)httpServletRequest);
        ResponseParams resultUid = this.userInfoService.selectUserByUid(uid);
        if (!CommonRetCode.SUCCESS.equalTo(resultUid.getCode())) {
            log.error("User [{}] not existed.", (Object)uid);
            result = new ResponseParams(CommonRetCode.DATA_NOT_EXISTED.getCode(), CommonRetCode.DATA_NOT_EXISTED.getMsg(), null);
            return RestResponseUtils.jointRestResponse((ResponseParams)result);
        }
        UserInfoDto userInfo = (UserInfoDto)resultUid.getData();
        request.setUid(userInfo.getUid());
        request.setAge(userInfo.getAge());
        request.setLevelCode(this.getUserLevelCodeOrDefault(userInfo));
        String cacheKey = String.format("LEXILE:EVA:CREATE:%s:%d", request.getUid(), request.getCurrentEvaluationId());
        try {
            result = !this.ccl.setLock(cacheKey, 30) ? new ResponseParams(CommonRetCode.REQUEST_DUPLICATION) : this.lexileLevelHistoryService.createLexileHistory(request);
        }
        finally {
            this.ccl.releaseLock(cacheKey);
        }
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u84dd\u601d\u8bc4\u6d4b\u4ea4\u5377--APP", notes="\u84dd\u601d\u8bc4\u6d4b\u4ea4\u5377--\u97e9\u8302\u4e30", response=LexileAnswerResponse.class)
    @RequestMapping(value={"/handover/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> handover(@RequestBody LexileEvalutionHandOverRequest request, HttpServletRequest httpServletRequest) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)httpServletRequest, (Object)request);
        ResponseParams result = null;
        String cacheKey = String.format("LEXILE:EVA:HANDOVER:%s:%d", request.getUid(), request.getHistoryId());
        try {
            result = !this.ccl.setLock(cacheKey, 30) ? new ResponseParams(CommonRetCode.REQUEST_DUPLICATION) : this.lexileLevelHistoryService.handover(request);
        }
        finally {
            this.ccl.releaseLock(cacheKey);
        }
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    private LexileEvaluationDto getUserMatchLexilEvaluation(UserInfoDto ud) {
        LexileEvaluationDto eva = null;
        String levelCode = this.getUserLevelCodeOrDefault(ud);
        ResponseParams evaResp = this.lexileEvaluationService.getEvaluationByLevelCode(levelCode);
        if (CommonRetCode.isSuccess((String)evaResp.getCode())) {
            eva = (LexileEvaluationDto)evaResp.getData();
        }
        return eva;
    }

    private LexileEvaluationDto getLevelCodeMatchLexilEvaluation(String levelCode) {
        LexileEvaluationDto eva = null;
        ResponseParams evaResp = this.lexileEvaluationService.getEvaluationByLevelCode(levelCode);
        if (CommonRetCode.isSuccess((String)evaResp.getCode())) {
            eva = (LexileEvaluationDto)evaResp.getData();
        }
        return eva;
    }

    private String getUserLevelCodeOrDefault(UserInfoDto userInfo) {
        String lexileLevel = userInfo.getLexileLevel();
        String levelCode = this.levelService.transferLexileLevel(lexileLevel);
        if (StringUtils.isBlank((CharSequence)levelCode)) {
            levelCode = LevelEnum.LV0.getCode();
        }
        return levelCode;
    }

    @ApiOperation(value="\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--APP", notes="\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--\u97e9\u8302\u4e30", response=LexileEvaHistoryDetailDto.class)
    @RequestMapping(value={"/history-detail/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> historyDetail(@RequestParam(value="historyId", required=true) Integer historyId, HttpServletRequest httpServletRequest) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)httpServletRequest);
        String uid = initialization.getUid();
        return RestResponseUtils.jointRestResponse((ResponseParams)this.lexileLevelHistoryService.historyDetail(historyId, uid));
    }

    @ApiOperation(value="\u6307\u5b9a\u7b49\u7ea7\u4e0b\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--APP", notes="\u6307\u5b9a\u7b49\u7ea7(\u8bc4\u6d4b\u540e)\u4e0b\u6700\u5927\u5206\u503c\u7684\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--\u97e9\u8302\u4e30", response=LexileEvaHistoryDetailDto.class)
    @RequestMapping(value={"/history-detail-by-levelcode/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> historyDetailByLevelcode(@RequestParam(value="levelCode", required=true) String levelCode, HttpServletRequest httpServletRequest) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)httpServletRequest);
        String uid = initialization.getUid();
        return RestResponseUtils.jointRestResponse((ResponseParams)this.lexileLevelHistoryService.maxScoreHistoryDetailByLevelCode(levelCode, uid));
    }

    @ApiOperation(value="\u6307\u5b9a\u539f\u59cb\u7b49\u7ea7\u4e0b\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--APP", notes="\u6307\u5b9a\u7b49\u7ea7(\u8bc4\u6d4b\u524d)\u4e0b\u6700\u5927\u5206\u503c\u7684\u84dd\u601d\u8bc4\u6d4b\u8bb0\u5f55\u8be6\u60c5--\u97e9\u8302\u4e30", response=LexileEvaHistoryDetailDto.class)
    @RequestMapping(value={"/history-detail-by-origin-levelcode/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> historyDetailByOriginLevelcode(@RequestParam(value="levelCode", required=true) String levelCode, HttpServletRequest httpServletRequest) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)httpServletRequest);
        String uid = initialization.getUid();
        return RestResponseUtils.jointRestResponse((ResponseParams)this.lexileLevelHistoryService.maxScoreHistoryDetailByOriginLevelCode(levelCode, uid));
    }

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u52a8\u8bc4\u6d4b\u9875\u9762\u4fe1\u606f--APP", notes="\u8fd4\u56de\u4e3b\u52a8\u8bc4\u6d4b\u9875\u9762\u4fe1\u606f--wangshuzheng", response=GetInitiativeInfoResponse.class)
    @RequestMapping(value={"/getInitiativeInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getInitiativeInfo(HttpServletRequest httpServletRequest) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)httpServletRequest);
        String uid = initialization.getUid();
        return RestResponseUtils.jointRestResponse((ResponseParams)this.lexileLevelHistoryService.getInitiativeInfo(uid));
    }

    @ApiOperation(value="\u8fd4\u56de\u7528\u6237\u5f53\u524d\u84dd\u601d\u6307\u6570\u5bf9\u5e94\u7684\u7b49\u7ea7\u4ee5\u53ca\u7b49\u7ea7\u4fe1\u606f--APP", notes="\u8fd4\u56de\u7528\u6237\u5f53\u524d\u84dd\u601d\u6307\u6570\u5bf9\u5e94\u7684\u7b49\u7ea7\u4ee5\u53ca\u7b49\u7ea7\u4fe1\u606f--wangshuzheng", response=GetLevelInfoResponse.class)
    @RequestMapping(value={"/getLevelInfo/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> getLevelInfo(HttpServletRequest httpServletRequest) throws IOException {
        HeadParamDto initialization = HeadParamInitializationUtil.Initialization((HttpServletRequest)httpServletRequest);
        String uid = initialization.getUid();
        return RestResponseUtils.jointRestResponse((ResponseParams)this.lexileLevelHistoryService.getLevelInfo(uid));
    }

    @ApiOperation(value="\u84dd\u601d\u8bc4\u6d4b\u6d4b\u8bc4\u6b21\u6570--APP", response=LexileAnswerResponse.class)
    @RequestMapping(value={"/evaluation-time/v1"}, method={RequestMethod.GET})
    public ResponseEntity<?> evaluationTime(HttpServletRequest httpServletRequest) throws IOException {
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)httpServletRequest);
        ResponseParams result = this.userInfoService.getEvaluationTime(uid);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

