/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.alibaba.fastjson.JSONObject;
import com.ella.common.dto.BaseBookDto;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.CourseService;
import com.ella.resource.dto.CourseListDto;
import com.ella.resource.dto.CourseQuestionListDto;
import com.ella.resource.dto.request.AddCourseQestionRes;
import com.ella.resource.dto.request.BaseBookListRes;
import com.ella.resource.dto.request.ChangeCourseQuestionIndexRes;
import com.ella.resource.dto.request.CourseQuestionListReq;
import com.ella.resource.dto.request.CourseRequest;
import com.ella.resource.dto.request.CourseVedioReq;
import com.ella.resource.dto.request.GetCourseInfoReq;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/course/"})
@Api(description="OTS\u8bfe\u7a0b")
public class CourseRest {
    private static final Logger log = LogManager.getLogger(CourseRest.class);
    @Autowired
    private CourseService courseService;

    @ApiOperation(value="\u8bfe\u7a0b/\u7ed8\u672c\u52a8\u753b\u4e66\u6dfb\u52a0", notes="\u8bfe\u7a0b/\u7ed8\u672c\u52a8\u753b\u4e66\u6dfb\u52a0--zln", response=BaseBookDto.class)
    @RequestMapping(value={"selectBookList/v1"}, method={RequestMethod.POST})
    public ResponseEntity selectBookList(@RequestBody BaseBookListRes res) {
        ResponseParams responseParams = this.courseService.selectBookList(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u83b7\u53d6\u8be6\u60c5\u9875", notes="\u8bfe\u7a0b\u83b7\u53d6\u8be6\u60c5\u9875--zln", response=CourseListDto.class)
    @RequestMapping(value={"getCourseInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity getCourseInfo(@RequestBody GetCourseInfoReq req) {
        log.info("getCourseInfo/v1 args--> {}", (Object)req.getId());
        ResponseParams courseInfo = this.courseService.getCourseInfo(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)courseInfo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u89c6\u9891\u63a5\u53e3", notes="\u6dfb\u52a0\u89c6\u9891\u63a5\u53e3--zln")
    @RequestMapping(value={"addCourseVedio/v1"}, method={RequestMethod.POST})
    public ResponseEntity addCourseVedio(@RequestBody CourseVedioReq req) {
        log.info("addCourseVedio/v1 args--> {}", (Object)JSONObject.toJSONString((Object)req));
        ResponseParams responseParams = this.courseService.addCourseVedio(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u5217\u8868\u63a5\u53e3--\u5206\u9875", notes="\u8bfe\u7a0b\u5217\u8868\u63a5\u53e3--zln", response=CourseListDto.class)
    @RequestMapping(value={"v1/courseList"}, method={RequestMethod.POST})
    public ResponseEntity courseList(@RequestBody CourseRequest request) {
        log.info("addCourseVedio/v1 args--> {}", (Object)JSONObject.toJSONString((Object)request));
        ResponseParams responseParams = this.courseService.courseList(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u65b0\u589e\u8bfe\u7a0b", notes="\u65b0\u589e\u8bfe\u7a0b--zln", response=Boolean.class)
    @RequestMapping(value={"v1/addCourse"}, method={RequestMethod.POST})
    public ResponseEntity addCourse(@RequestBody CourseListDto dto) {
        log.info("addCourse/v1 args--> {}", (Object)JSONObject.toJSONString((Object)dto));
        ResponseParams responseParams = this.courseService.addCourse(dto);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u6dfb\u52a0\u9898\u76ee", notes="\u8bfe\u7a0b\u6dfb\u52a0\u9898\u76ee--zln")
    @RequestMapping(value={"v1/addCourseQestion"}, method={RequestMethod.POST})
    public ResponseEntity addCourseQestion(@RequestBody AddCourseQestionRes res) {
        ResponseParams responseParams = this.courseService.addCourseQestion(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u4e60\u9898\u4fee\u6539\u4f4d\u7f6e", notes="\u8bfe\u7a0b\u4e60\u9898\u4fee\u6539\u4f4d\u7f6e--zln")
    @RequestMapping(value={"v1/changeCourseQuestionIndex"}, method={RequestMethod.POST})
    public ResponseEntity changeCourseQuestionIndex(@RequestBody ChangeCourseQuestionIndexRes res) {
        ResponseParams responseParams = this.courseService.changeCourseQuestionIndex(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u9898\u76ee\u5217\u8868", notes="\u8bfe\u7a0b\u9898\u76ee\u5217\u8868--zln", response=CourseQuestionListDto.class)
    @RequestMapping(value={"v1/courseQuestionList"}, method={RequestMethod.POST})
    public ResponseEntity courseQuestionList(@RequestBody CourseQuestionListReq res) {
        ResponseParams responseParams = this.courseService.courseQuestionList(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u9898\u76ee\u5217\u8868\u5220\u9664\u9898\u76ee", notes="\u8bfe\u7a0b\u9898\u76ee\u5217\u8868\u5220\u9664\u9898\u76ee--zln", response=Integer.class)
    @RequestMapping(value={"v1/courseQuestionDel"}, method={RequestMethod.POST})
    public ResponseEntity courseQuestionDel(@RequestBody CourseQuestionListReq res) {
        ResponseParams responseParams = this.courseService.courseQuestionDel(res);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u8bfe\u7a0b\u4fee\u6539", notes="\u8bfe\u7a0b\u4fee\u6539--zln")
    @RequestMapping(value={"v1/updateCourse"}, method={RequestMethod.POST})
    public ResponseEntity updateCourse(@RequestBody CourseListDto dto) {
        ResponseParams responseParams = this.courseService.updateCourse(dto);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }
}

