/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.goods;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.order.api.GoodsService;
import com.ella.order.dto.goods.GetBookGoodsListByPageRequest;
import com.ella.order.dto.goods.GetGoodsDetailByItemCodeAndTypeRequest;
import com.ella.order.dto.goods.GetGoodsDetailRequest;
import com.ella.order.dto.goods.GetGoodsListByPageRequest;
import com.ella.order.dto.goods.GetGoodsListRequest;
import com.ella.order.dto.goods.GetMissionOfMapTotalByItemCode;
import com.ella.order.dto.goods.GetSupportPayTypeByGoodsCodeRequest;
import com.ella.order.dto.goods.GoodsDto;
import com.ella.order.dto.goods.GoodsFullDto;
import com.ella.order.dto.goods.ModifyGoodsRequest;
import com.ella.order.dto.goods.ModifyGoodsStatusRequest;
import com.ella.order.dto.goods.SaveGoodsRequest;
import com.ella.order.dto.goods.SummaryGoodsPriceDto;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/goods/"})
@Api(description="\u5546\u54c1\u670d\u52a1")
public class GoodsRest {
    private static final Logger log = LogManager.getLogger(GoodsRest.class);
    @Autowired
    private GoodsService goodsService;

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868,\u652f\u6301\u5206\u9875-\u8fd0\u8425\u5de5\u5177", notes="\u67e5\u8be2\u5546\u54c1\u5217\u8868,\u652f\u6301\u5206\u9875-\u8fd0\u8425\u5de5\u5177-chenshuai \u6ce8\uff1a1.\u7cfb\u7edf\u652f\u6301\u7684\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5927200\u6761 2.\u9488\u5bf9\u5206\u9875\u67e5\u8be2\uff0c\u8fd4\u56de\u7ed3\u679c\u96c6\u6570\u636e\u7ed3\u6784\u4ee5\u5177\u4f53\u8fd4\u56de\u62a5\u6587\u4e3a\u51c6", response=GoodsDto.class)
    @RequestMapping(path={"getGoodsListByPage/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsListByPage(@RequestBody GetGoodsListByPageRequest req) {
        ResponseParams result = this.goodsService.getGoodsListByPage(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP/\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u5546\u54c1\u8be6\u60c5", notes="\u67e5\u8be2\u5546\u54c1\u8be6\u60c5-APP/\u8fd0\u8425\u5de5\u5177-chenshuai", response=GoodsDto.class)
    @RequestMapping(path={"getGoodsDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsDetail(@RequestBody GetGoodsDetailRequest req) {
        ResponseParams result = this.goodsService.getGoodsDetail(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u65b0\u589e\u5546\u54c1", notes="\u8fd0\u8425\u5de5\u5177-\u65b0\u589e\u5546\u54c1-chenshuai", response=Boolean.class)
    @RequestMapping(path={"saveGoods/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> saveGoods(@RequestBody SaveGoodsRequest req) {
        String uid = ContextUtils.getUid();
        if (uid != null) {
            req.setUserId(uid);
        }
        ResponseParams result = this.goodsService.saveGoods(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u7f16\u8f91\u5546\u54c1", notes="\u8fd0\u8425\u5de5\u5177-\u7f16\u8f91\u5546\u54c1-chenshuai", response=Boolean.class)
    @RequestMapping(path={"modifyGoods/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> modifyGoods(@RequestBody ModifyGoodsRequest req) {
        String uid = ContextUtils.getUid();
        if (uid != null) {
            req.setUserId(uid);
        }
        ResponseParams result = this.goodsService.modifyGoods(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u5546\u54c1\u4e0a\u4e0b\u67b6", notes="\u8fd0\u8425\u5de5\u5177-\u5546\u54c1\u4e0a\u4e0b\u67b6-chenshuai", response=Boolean.class)
    @RequestMapping(path={"modifyGoodsState/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> modifyGoodsState(@RequestBody ModifyGoodsStatusRequest req) {
        String uid = ContextUtils.getUid();
        if (uid != null) {
            req.setUserId(uid);
        }
        ResponseParams result = this.goodsService.modifyGoodsState(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u67e5\u8be2\u5546\u54c1\u5217\u8868", notes="\u67e5\u8be2\u5546\u54c1\u5217\u8868\uff08\u6ce8\uff1a\u53ea\u5305\u542b\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\uff0capp\u6839\u636e\u9700\u8981\u4f7f\u7528\uff0c\u975e\u5fc5\u987b\u63a5\u53e3\uff09\u3002\u5f53\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u8d85\u8fc7\u4e24\u767e\u6761\uff0c\u7cfb\u7edf\u6700\u591a\u8fd4\u56de200\u6761\u6570\u636e", response=GoodsDto.class)
    @RequestMapping(path={"getGoodsList/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsList(@RequestBody GetGoodsListRequest req) {
        ResponseParams result = this.goodsService.getGoodsList(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u8fd0\u8425\u5de5\u5177-\u67e5\u8be2\u7ed8\u672c\u5546\u54c1\u5217\u8868", notes="\u67e5\u8be2\u7ed8\u672c\u5546\u54c1\u5217\u8868\u3002\u5f53\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u8d85\u8fc7\u4e24\u767e\u6761\uff0c\u7cfb\u7edf\u6700\u591a\u8fd4\u56de200\u6761\u6570\u636e", response=GoodsFullDto.class)
    @RequestMapping(path={"getBookGoodsListByPage/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> getBookGoodsListByPage(@RequestBody GetBookGoodsListByPageRequest req) {
        ResponseParams result = this.goodsService.getBookGoodsListByPage(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801\u67e5\u8be2 \u5546\u54c1\u8be6\u60c5", notes="APP-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801\u67e5\u8be2 \u5546\u54c1\u8be6\u60c5-chenshuai (\u6ce8\uff1a1.\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff0c\u8fd4\u56de\u7684data=null,2.\u53ea\u8fd4\u56de\u5546\u54c1\u72b6\u6001\u4e3a\u5df2\u4e0a\u67b6\u6216\u5df2\u4e0b\u67b6\u7684\u5546\u54c1\u4fe1\u606f)", response=GoodsFullDto.class)
    @RequestMapping(path={"getGoodsDetailByItemCodeAndType/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsDetailByItemCodeAndType(@RequestBody GetGoodsDetailByItemCodeAndTypeRequest req) {
        ResponseParams result = this.goodsService.getGoodsDetailByItemCodeAndType(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801 \u67e5\u8be2\u5546\u54c1\u4ef7\u683c/\u7528\u6237\u8d26\u6237\u4f59\u989d\u6c47\u603b\u4fe1\u606f", notes="APP-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801 \u67e5\u8be2\u5546\u54c1\u4ef7\u683c/\u7528\u6237\u8d26\u6237\u4f59\u989d\u6c47\u603b\u4fe1\u606f-chenshuai ", response=SummaryGoodsPriceDto.class)
    @RequestMapping(path={"getSummrayGoodsByItemCodeAndType/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getSummrayGoodsByItemCodeAndType(@RequestBody GetGoodsDetailByItemCodeAndTypeRequest req, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)req);
        ResponseParams result = this.goodsService.getSummrayGoodsByItemCodeAndType(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP/OTS-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u5730\u56fe\u6536\u8d39\u5173\u5361\u7d2f\u52a0\u91d1\u989d", notes="APP/OTS-\u6839\u636e \u7c7b\u578b+\u7269\u54c1\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u5730\u56fe\u6536\u8d39\u5173\u5361\u7d2f\u52a0\u91d1\u989d-chenshuai ", response=String.class)
    @RequestMapping(path={"getMissionOfMapTotal/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getGoodsDetailByItemCodeAndType(@RequestBody GetMissionOfMapTotalByItemCode req) {
        ResponseParams result = this.goodsService.getMissionOfMapTotal(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="APP-\u6839\u636e\u5546\u54c1\u7f16\u7801\u67e5\u8be2\u652f\u6301\u7684\u652f\u4ed8\u65b9\u5f0f", notes="APP-\u6839\u636e\u5546\u54c1\u7f16\u7801\u67e5\u8be2\u652f\u6301\u7684\u652f\u4ed8\u65b9\u5f0f-chenshuai(\u6ce8\uff1a\u6839\u636e\u9700\u8981\u4f7f\u7528)", response=String.class)
    @RequestMapping(path={"getSupportPayTypeByGoodsCode/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getSupportPayTypeByGoodsCode(@RequestBody GetSupportPayTypeByGoodsCodeRequest req) {
        ResponseParams result = this.goodsService.getSupportPayTypeByGoodsCode(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

