/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.exception;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import com.ella.frame.common.errorcode.OfflineEnum;
import com.ella.frame.common.response.ResponseParams;
import com.ella.rest.exception.LimitDeviceException;
import com.ella.rest.util.RestResponseUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LogManager.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<ErrorMessage> clientAuthenticationExceptionHandler(HttpServletRequest req, Exception e) throws Exception {
        ResponseEntity response = new ResponseEntity((Object)ErrorMessage.valueOf((CommonRetCode)CommonRetCode.SERVER_ERROR), HttpStatus.INTERNAL_SERVER_ERROR);
        log.error("\u670d\u52a1\u5668\u5f02\u5e38", (Throwable)e);
        return response;
    }

    @ExceptionHandler(value={ClientAuthenticationException.class})
    @ResponseBody
    public ResponseEntity<ErrorMessage> clientAuthenticationExceptionHandler(HttpServletRequest req, ClientAuthenticationException e) throws Exception {
        ResponseEntity response = new ResponseEntity((Object)ErrorMessage.valueOf((CommonRetCode)CommonRetCode.UNAUTHORIZED), HttpStatus.OK);
        log.error("\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
        return response;
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    @ResponseBody
    public ResponseEntity<ErrorMessage> invalidTokenExceptionHandler(HttpServletRequest req, InvalidTokenException e) throws Exception {
        if (e instanceof LimitDeviceException) {
            ResponseParams result = new ResponseParams(CommonRetCode.FORCED_OFFLINE_ERROR);
            result.setMessage(OfflineEnum.getMsgByCode((String)e.getMessage()));
            return RestResponseUtils.jointRestResponseNoT((ResponseParams)result);
        }
        ResponseEntity response = new ResponseEntity((Object)ErrorMessage.valueOf((CommonRetCode)CommonRetCode.SESSION_INVALID), HttpStatus.OK);
        log.error("\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
        return response;
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ResponseEntity<ErrorMessage> accessDeniedExceptionHandler(HttpServletRequest req, AccessDeniedException e) throws Exception {
        ResponseEntity response = new ResponseEntity((Object)ErrorMessage.valueOf((CommonRetCode)CommonRetCode.FORBIDDEN), HttpStatus.FORBIDDEN);
        log.error("\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
        return response;
    }

    @ExceptionHandler(value={LimitDeviceException.class})
    @ResponseBody
    public ResponseEntity limitDeviceExceptionHandler(HttpServletRequest req, Exception e) throws Exception {
        ResponseParams result = new ResponseParams(CommonRetCode.FORCED_OFFLINE_ERROR);
        result.setMessage(OfflineEnum.getMsgByCode((String)e.getMessage()));
        return RestResponseUtils.jointRestResponseNoT((ResponseParams)result);
    }
}

