/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.rest.configuration.RequestHeadAuthorizationFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.http.MimeHeaders;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="requestHeadAuthorizationFilter")
public class RequestHeadAuthorizationFilter
extends OncePerRequestFilter
implements EnvironmentAware {
    private static final Logger log = LogManager.getLogger(RequestHeadAuthorizationFilter.class);
    private Environment environment;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String permitAllUrls = this.environment.getProperty("permit.urls");
        String[] permitUrls = permitAllUrls.split(",");
        if (this.checkUrlBeforeAuthenticate((ServletRequest)request, permitUrls)) {
            filterChain.doFilter((ServletRequest)new CustomRequest(this, request), (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private boolean checkUrlBeforeAuthenticate(ServletRequest request, String[] permitUrls) {
        AntPathMatcher antPathMatcher = this.createMatcher(true);
        for (String permitUrl : permitUrls) {
            if (!antPathMatcher.match(permitUrl, this.getRequestPath((HttpServletRequest)request))) continue;
            return true;
        }
        return false;
    }

    private AntPathMatcher createMatcher(boolean caseSensitive) {
        AntPathMatcher matcher = new AntPathMatcher();
        matcher.setTrimTokens(false);
        matcher.setCaseSensitive(caseSensitive);
        return matcher;
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + request.getPathInfo();
        }
        return url;
    }

    private void reflectSetHeader(HttpServletRequest request, String key, String value) {
        Class<?> requestClass = request.getClass();
        log.info("request class {}", (Object)requestClass.getName());
        try {
            Field request1 = requestClass.getDeclaredField("request");
            request1.setAccessible(true);
            Object o = request1.get(request);
            Field coyoteRequest = o.getClass().getDeclaredField("coyoteRequest");
            coyoteRequest.setAccessible(true);
            Object o1 = coyoteRequest.get(o);
            log.info("coyoteRequest class {}", (Object)o1.getClass().getName());
            Field headers = o1.getClass().getDeclaredField("headers");
            headers.setAccessible(true);
            MimeHeaders o2 = (MimeHeaders)headers.get(o1);
            o2.addValue(key).setString(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

