/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.configuration;

import com.ella.frame.cache.DistributedCache;
import com.ella.frame.cache.UserDeviceUtils;
import com.ella.frame.common.errorcode.OfflineEnum;
import com.ella.frame.common.util.HeadParamTl;
import com.ella.resource.config.HeadParamUtil;
import com.ella.rest.configuration.CustomServerTokenServices;
import com.ella.rest.exception.LimitDeviceException;
import com.ella.user.auth.dto.MyUserDetails;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.CollectionUtils;

public class CustomOAuth2AuthenticationManager
extends OAuth2AuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(CustomOAuth2AuthenticationManager.class);
    private ResourceServerTokenServices tokenServices;
    private ClientDetailsService clientDetailsService;
    private DistributedCache distributedCache;
    private TokenStore tokenStore;
    private Integer renewHour;
    private String resourceId;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AuthenticationDetails details;
        if (authentication == null) {
            log.error("Authentication fail:token not found");
            throw new InvalidTokenException("Invalid token (token not found)");
        }
        String token = (String)authentication.getPrincipal();
        log.info("method authenticate: request token is {}", (Object)token);
        CustomServerTokenServices tokenServicesTmp = new CustomServerTokenServices(this.tokenStore);
        OAuth2Authentication auth = tokenServicesTmp.loadAuthentication(token);
        OAuth2AccessToken accessToken = this.tokenServices.readAccessToken(token);
        log.info("method authenticate: request accessToken is {}", (Object)accessToken);
        if (this.checkIfwillExpired(accessToken.getExpiration())) {
            this.renewToken(auth, accessToken, this.renewHour.intValue());
        }
        if (auth == null) {
            log.error("Authentication fail:Invalid token {}", (Object)token);
            throw new InvalidTokenException("Invalid token: " + token);
        }
        Set resourceIds = auth.getOAuth2Request().getResourceIds();
        if (this.resourceId != null && resourceIds != null && !resourceIds.isEmpty() && !resourceIds.contains(this.resourceId)) {
            log.error("Authentication fail:does not contain resource id {}", (Object)this.resourceId);
            throw new OAuth2AccessDeniedException("Invalid token does not contain resource id (" + this.resourceId + ")");
        }
        this.checkClientDetails(auth);
        if (authentication.getDetails() instanceof OAuth2AuthenticationDetails && !(details = (OAuth2AuthenticationDetails)authentication.getDetails()).equals(auth.getDetails())) {
            details.setDecodedDetails(auth.getDetails());
        }
        auth.setDetails(authentication.getDetails());
        auth.setAuthenticated(true);
        this.limitDeviceAndOffline(auth, accessToken);
        return auth;
    }

    private boolean checkIfwillExpired(Date expiredDate) {
        Calendar nowCal = Calendar.getInstance();
        nowCal.add(11, this.renewHour);
        return nowCal.getTime().after(expiredDate);
    }

    private void renewToken(OAuth2Authentication auth, OAuth2AccessToken accessToken, int renewtime) {
        DefaultOAuth2AccessToken myAccessToken = (DefaultOAuth2AccessToken)accessToken;
        Calendar cal = Calendar.getInstance();
        cal.setTime(myAccessToken.getExpiration());
        cal.add(11, renewtime);
        myAccessToken.getValue();
        myAccessToken.setExpiration(cal.getTime());
        try {
            Authentication authentication = auth.getUserAuthentication();
            Map map = (Map)authentication.getDetails();
            String username = (String)map.get("username");
            this.distributedCache.expireAt("LAST_LOGIN:" + username, cal.getTime());
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u7528\u6237\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        this.tokenStore.storeAccessToken((OAuth2AccessToken)myAccessToken, auth);
    }

    private void checkClientDetails(OAuth2Authentication auth) {
        if (this.clientDetailsService != null) {
            ClientDetails client;
            try {
                client = this.clientDetailsService.loadClientByClientId(auth.getOAuth2Request().getClientId());
            }
            catch (ClientRegistrationException e) {
                log.error("Authentication fail:{}", (Throwable)e);
                throw new OAuth2AccessDeniedException("Invalid token contains invalid client id");
            }
            Set allowed = client.getScope();
            for (String scope : auth.getOAuth2Request().getScope()) {
                if (allowed.contains(scope)) continue;
                log.error("Authentication fail:Invalid token contains disallowed scope {} for this client", (Object)scope);
                throw new OAuth2AccessDeniedException("Invalid token contains disallowed scope (" + scope + ") for this client");
            }
        }
    }

    private void limitDeviceAndOffline(OAuth2Authentication auth, OAuth2AccessToken accessToken) {
        Authentication userAuthentication = auth.getUserAuthentication();
        if (Objects.isNull(userAuthentication)) {
            log.error("method authenticate:get userAuthentication is null by token!");
            return;
        }
        MyUserDetails user = (MyUserDetails)userAuthentication.getPrincipal();
        HeadParamTl headParam = HeadParamUtil.getHeadParamTl();
        OfflineEnum offlineEnum = new UserDeviceUtils(this.distributedCache).limitDeviceCheck(user.getUsername(), headParam.getDeviceNo());
        if (Objects.nonNull(offlineEnum)) {
            this.tokenStore.removeAccessToken(accessToken);
            log.info("method authenticate: userName {} corresponding accessToken {} is removed", (Object)user.getUsername(), (Object)accessToken.getValue());
            log.info("method authenticate: removeAccessToken is {}", (Object)accessToken);
            throw new LimitDeviceException(offlineEnum.getCode());
        }
    }

    private boolean queryAndRemove(String userName, HeadParamTl headParam, String offlineDevice) {
        String currentRole = Optional.ofNullable(headParam.getDeviceNo()).orElse("other");
        StringBuilder key = new StringBuilder(userName);
        key.append("#").append(currentRole).append("#").append(offlineDevice);
        Collection offlineTokens = this.tokenStore.findTokensByClientIdAndUserName("ellaenglish_app", key.toString());
        if (CollectionUtils.isEmpty((Collection)offlineTokens)) {
            return true;
        }
        offlineTokens.forEach(o -> {
            this.tokenStore.removeAccessToken(o);
            log.info("method limitDeviceAndOffline: userName {} corresponding accessToken {} is removed", (Object)key.toString(), (Object)o.getValue());
        });
        return false;
    }

    public ResourceServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setTokenServices(ResourceServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setRenewHour(Integer renewHour) {
        this.renewHour = renewHour;
    }

    public DistributedCache getDistributedCache() {
        return this.distributedCache;
    }

    public void setDistributedCache(DistributedCache distributedCache) {
        this.distributedCache = distributedCache;
    }
}

