/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.aspect;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Aspect
@Service
public class RestLogAspect {
    private static final Logger log = LogManager.getLogger(RestLogAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) ||@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void requestMappingPointcut() {
    }

    @Pointcut(value="@annotation(io.swagger.annotations.ApiOperation)")
    public void apiOperationPointcut() {
    }

    @Pointcut(value="execution(public org.springframework.http.ResponseEntity com.ella.rest.*.*.*(..))")
    public void packagePointcut() {
    }

    @Pointcut(value="requestMappingPointcut() && apiOperationPointcut() &&  packagePointcut()")
    public void myPointcut() {
    }

    @Around(value="myPointcut()")
    public ResponseEntity<?> interceptor(ProceedingJoinPoint joinPoint) {
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        long t1 = System.currentTimeMillis();
        if (null == args || args.length < 1 || methodName.equals("upload")) {
            log.info("method {} ", (Object)methodName);
        } else {
            log.info("method {} request is {}", (Object)methodName, (Object)args[0].toString());
        }
        try {
            ResponseEntity result = (ResponseEntity)joinPoint.proceed(args);
            log.info("method {} result is :{}", (Object)methodName, (Object)JSONObject.toJSONString((Object)result));
            log.info("method {} elapsed time:{}", (Object)methodName, (Object)(System.currentTimeMillis() - t1));
            return result;
        }
        catch (Throwable e) {
            log.error("method {} \u7cfb\u7edf\u5f02\u5e38", (Object)methodName, (Object)e);
            return new ResponseEntity((Object)new ErrorMessage(CommonRetCode.SERVER_ERROR.getCode(), CommonRetCode.SERVER_ERROR.getMsg(), (Object)e.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

