/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.util;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.errorcode.ErrorMessage;
import com.ella.frame.common.response.ResponseParams;
import com.ella.user.auth.dto.MyUserDetails;
import com.ella.user.utils.ContextUtils;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class RestResponseUtils {
    public static <T> ResponseEntity<?> jointRestResponse(ResponseParams<T> result) {
        RestResponseUtils.dataCheck(result);
        return RestResponseUtils.jointRestResponse(result, (boolean)false);
    }

    public static <T> ResponseEntity<?> jointRestResponse(ResponseParams<T> result, boolean notSuccessWithData) {
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            result.setStatus(ResponseParams.STATUS_FAILURE);
            if (notSuccessWithData) {
                return new ResponseEntity(result, HttpStatus.OK);
            }
            return new ResponseEntity((Object)new ErrorMessage(result.getCode(), result.getMessage(), result.getData()), HttpStatus.OK);
        }
        MyUserDetails userDetails = ContextUtils.getSession();
        result.setStatus(ResponseParams.STATUS_SUCCEED);
        if (Objects.nonNull(userDetails) && Objects.nonNull(userDetails.getIsVip())) {
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"levelCode", (Object)userDetails.getLevelCode());
            headers.add((Object)"isVip", (Object)userDetails.getIsVip());
            headers.add((Object)"available", (Object)(userDetails.getAvailable() + ""));
            return new ResponseEntity(result, (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    public static ResponseEntity jointRestResponseNoT(ResponseParams result) {
        RestResponseUtils.dataCheck((ResponseParams)result);
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode())) {
            result.setStatus(ResponseParams.STATUS_FAILURE);
            return new ResponseEntity((Object)new ErrorMessage(result.getCode(), result.getMessage(), result.getData()), HttpStatus.OK);
        }
        result.setStatus(ResponseParams.STATUS_SUCCEED);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    private static void dataCheck(ResponseParams result) {
        if (!CommonRetCode.SUCCESS.getCode().equals(result.getCode()) && result.getData() instanceof String) {
            result.setData(null);
        }
    }
}

