/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.ella.frame.common.response.ResponseParams;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.MenuService;
import com.ella.user.api.UserOtsService;
import com.ella.user.dto.menu.MenuDto;
import com.ella.user.dto.userots.AddUserOtsRequest;
import com.ella.user.dto.userots.EditUserOtsRequest;
import com.ella.user.dto.userots.ListUserOtsRequest;
import com.ella.user.dto.userots.UserOtsDto;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user-ots"})
@Api(description="OTS\u7528\u6237")
public class UserOtsRest {
    private static final Logger log = LogManager.getLogger(UserOtsRest.class);
    @Autowired
    UserOtsService userOtsService;
    @Autowired
    MenuService menuService;

    @ApiOperation(value="\u65b0\u589eOTS\u7528\u6237-\u8fd0\u8425\u5de5\u5177", notes="\u65b0\u589eOTS\u7528\u6237-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/add/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> add(@RequestBody AddUserOtsRequest request) {
        ResponseParams result = this.userOtsService.add(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91OTS\u7528\u6237-\u8fd0\u8425\u5de5\u5177", notes="\u7f16\u8f91OTS\u7528\u6237-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/edit/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> edit(@RequestBody EditUserOtsRequest request) {
        ResponseParams result = this.userOtsService.edit(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="OTS\u7528\u6237\u5217\u8868-\u8fd0\u8425\u5de5\u5177", notes="OTS\u7528\u6237\u5217\u8868-\u97e9\u8302\u4e30", response=UserOtsDto.class)
    @RequestMapping(path={"/list/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> list(@RequestBody ListUserOtsRequest request) {
        ResponseParams result = this.userOtsService.list(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="OTS\u7528\u6237\u83dc\u5355-\u8fd0\u8425\u5de5\u5177", notes="OTS\u7528\u6237\u83dc\u5355-\u97e9\u8302\u4e30", response=MenuDto.class)
    @RequestMapping(path={"/menus/v1"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> menus() {
        ResponseParams result = this.menuService.menusByUid(ContextUtils.getUid());
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

