/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.UserFeedbackService;
import com.ella.user.dto.AddUserFeedbackHandleRecordRequest;
import com.ella.user.dto.AddUserFeedbackRequest;
import com.ella.user.dto.GetUserFeedbackDetailRequest;
import com.ella.user.dto.ListUserFeedbackRequest;
import com.ella.user.dto.UserFeedbackDto;
import com.ella.user.dto.UserFeedbackHandleRecordDto;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user/feedback"})
@Api(description="\u7528\u6237\u53cd\u9988\u76f8\u5173\u63a5\u53e3")
public class UserFeedbackRest {
    private static final Logger log = LogManager.getLogger(UserFeedbackRest.class);
    @Autowired
    UserFeedbackService userFeedbackService;

    @ApiOperation(value="\u65b0\u589e\u53cd\u9988", notes="APP-\u65b0\u589e\u7528\u6237\u53cd\u9988-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/add/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> addUserfeedback(@RequestBody AddUserFeedbackRequest feedback, HttpServletRequest request1) throws Exception {
        log.info("Add user feedback [{}] ...", (Object)feedback);
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)feedback);
        ResponseParams result = this.userFeedbackService.feedback(feedback);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7528\u6237\u53cd\u9988\u5217\u8868", notes="\u8fd0\u8425\u5de5\u5177-\u5206\u9875\u67e5\u8be2\u7528\u6237\u53cd\u9988-\u97e9\u8302\u4e30", response=UserFeedbackDto.class)
    @RequestMapping(path={"/list/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> listNicknameCfg(@RequestBody ListUserFeedbackRequest request) {
        log.info("list user feedbacks [{}] ...", (Object)request);
        if ("CURRENT".equals(request.getUid())) {
            request.setUid(ContextUtils.getUid());
        }
        ResponseParams result = this.userFeedbackService.listUserFeedback(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u53cd\u9988\u5904\u7406\u8bb0\u5f55", notes="\u8fd0\u8425\u5de5\u5177-\u65b0\u589e\u7528\u6237\u53cd\u9988\u5904\u7406\u8bb0\u5f55-\u97e9\u8302\u4e30", response=UserFeedbackHandleRecordDto.class)
    @RequestMapping(path={"/handle/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> handle(@RequestBody AddUserFeedbackHandleRecordRequest request) {
        log.info("Add user feedback handle record request - [{}] ...", (Object)request);
        request.setUname(ContextUtils.getName());
        request.setCreateBy(ContextUtils.getUid());
        ResponseParams result = this.userFeedbackService.handle(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7528\u6237\u53cd\u9988\u8be6\u60c5", notes="\u8fd0\u8425\u5de5\u5177-\u7528\u6237\u53cd\u9988\u8be6\u60c5-\u97e9\u8302\u4e30", response=UserFeedbackDto.class)
    @RequestMapping(path={"/detail/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> detail(@RequestBody GetUserFeedbackDetailRequest request) {
        log.info("Get user feedback detail request - [{}] ...", (Object)request);
        ResponseParams result = this.userFeedbackService.detail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

