/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.ella.frame.common.response.ResponseParams;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.RoleService;
import com.ella.user.dto.role.AddRoleRequest;
import com.ella.user.dto.role.EditRoleRequest;
import com.ella.user.dto.role.RoleDto;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/role"})
@Api(description="\u89d2\u8272\u4fe1\u606f\u63a5\u53e3")
public class RoleRest {
    @Autowired
    RoleService roleService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u53ef\u7528\u89d2\u8272-\u8fd0\u8425\u5de5\u5177", notes="\u67e5\u8be2\u6240\u6709\u53ef\u7528\u89d2\u8272-\u97e9\u8302\u4e30", response=RoleDto.class)
    @RequestMapping(path={"/all/v1"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> all() {
        ResponseParams result = this.roleService.all();
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u65b0\u589e\u89d2\u8272-\u8fd0\u8425\u5de5\u5177", notes="\u65b0\u589e\u89d2\u8272-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/add/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> add(@RequestBody AddRoleRequest request) {
        ResponseParams result = this.roleService.add(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91\u89d2\u8272-\u8fd0\u8425\u5de5\u5177", notes="\u7f16\u8f91\u89d2\u8272-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/edit/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> edit(@RequestBody EditRoleRequest request) {
        ResponseParams result = this.roleService.edit(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272-\u8fd0\u8425\u5de5\u5177", notes="\u5220\u9664\u89d2\u8272-\u97e9\u8302\u4e30", response=Boolean.class)
    @RequestMapping(path={"/delete/v1"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> delete(@RequestParam(value="roleCode") String roleCode) {
        ResponseParams result = this.roleService.delete(roleCode, ContextUtils.getUid());
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

