/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.api.LexileLevelHistoryService;
import com.ella.user.dto.LexileLevelHistoryDto;
import com.ella.user.dto.request.lexile.LexileEvaluationRequest;
import com.ella.user.dto.request.lexile.LexileLevelRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/user/lexileEvaluation"})
@Api(description="\u7528\u6237\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u63a5\u53e3")
public class LexileLevelHistoryRest {
    private static final Logger log = LogManager.getLogger(LexileLevelHistoryRest.class);
    @Autowired
    LexileLevelHistoryService service;
    @Autowired
    com.ella.resource.api.LexileLevelHistoryService resService;

    @ApiOperation(value="\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u63a5\u53e3--app", notes="app-\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u63a5\u53e3--zhaojinliang", response=LexileLevelHistoryDto.class)
    @RequestMapping(path={"/getLexileEvalHistoryList/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLexileEvalHistoryList(@RequestBody LexileEvaluationRequest request, HttpServletRequest request1) throws Exception {
        log.info("\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u63a5\u53e3," + JSONObject.toJSONString((Object)request));
        if (request.getUid() == null) {
            HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        }
        ResponseParams result = this.service.getLexileEvalHistoryList(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u84dd\u601d\u8bc4\u6d4b\u8be6\u60c5\u63a5\u53e3--app", notes="app-\u67e5\u8be2\u5f53\u524d\u84dd\u601d\u8bc4\u6d4b\u8be6\u60c5\u63a5\u53e3--zhaojinliang", response=LexileLevelHistoryDto.class)
    @RequestMapping(path={"/getLexileEvalHistoryDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getLexileEvalHistoryDetail(@RequestBody LexileEvaluationRequest request, HttpServletRequest request1) throws Exception {
        log.info("\u67e5\u8be2\u5f53\u524d\u84dd\u601d\u8bc4\u6d4b\u8be6\u60c5\u63a5\u53e3," + JSONObject.toJSONString((Object)request));
        if (request.getUid() == null) {
            HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        }
        ResponseParams result = this.service.getLexileEvalHistoryDetail(request);
        this.handleWrongAnswerMissonInfo(result);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u8be6\u60c5\u63a5\u53e3--app", notes="app-\u67e5\u8be2\u6307\u5b9a\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u8be6\u60c5\u63a5\u53e3--zhaojinliang", response=LexileLevelHistoryDto.class)
    @RequestMapping(path={"/getOneLexileEvalHistoryDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getOneLexileEvalHistoryDetail(@RequestBody LexileLevelRequest request, HttpServletRequest request1) throws Exception {
        log.info("\u67e5\u8be2\u6307\u5b9a\u84dd\u601d\u8bc4\u6d4b\u5386\u53f2\u8be6\u60c5\u63a5\u53e3," + JSONObject.toJSONString((Object)request));
        if (request.getUid() == null) {
            HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        }
        ResponseParams result = this.service.getOneLexileEvalHistoryDetail(request);
        this.handleWrongAnswerMissonInfo(result);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    private void handleWrongAnswerMissonInfo(ResponseParams<LexileLevelHistoryDto> history) {
        ResponseParams mi;
        LexileLevelHistoryDto hd;
        if (CommonRetCode.isSuccess((String)history.getCode()) && Objects.nonNull(hd = (LexileLevelHistoryDto)history.getData()) && Boolean.FALSE.equals(hd.getPromotion()) && Objects.nonNull(mi = this.resService.wrongAnswerMissonInfoByHistoryId(hd.getId().intValue()))) {
            hd.setMissionInfo((List)mi.getData());
        }
    }
}

