/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.user;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.frame.common.util.HeadParamTl;
import com.ella.rest.util.RequestUtil;
import com.ella.rest.util.RestResponseUtils;
import com.ella.rest.util.ValidationUtils;
import com.ella.user.api.auth.AccountService;
import com.ella.user.api.auth.SecurityService;
import com.ella.user.dto.BindAndLoginVo;
import com.ella.user.dto.PlatformBindMobileReq;
import com.ella.user.dto.request.account.UnBindReq;
import com.ella.user.dto.user.CheckCodeConfirmRequest;
import com.ella.user.dto.user.PerfectKidInfoRequest;
import com.ella.user.dto.user.RegisterRequest;
import com.ella.user.dto.user.ResetPasswordRequest;
import com.ella.user.dto.user.UserDto;
import com.ella.user.dto.user.UserLoginRequest;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/account/"})
@Api(description="\u8d26\u6237\u76f8\u5173\u63a5\u53e3")
public class AccountRest {
    private static final Logger log = LogManager.getLogger(AccountRest.class);
    @Autowired
    AccountService accountService;
    @Autowired
    SecurityService securityService;

    @Deprecated
    @ApiOperation(value="\u672a\u6ce8\u518c\u7528\u6237\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u624b\u673a\u53f7", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6ce8\u518c--zln", response=Integer.class)
    @RequestMapping(value={"v1/newPlatformBindMobile"}, method={RequestMethod.POST})
    public ResponseEntity newPlatformBindMobile(@RequestBody PlatformBindMobileReq req) {
        RequestUtil.fillHeadParamTl((HeadParamTl)req);
        ResponseParams responseParams = this.accountService.newPlatformBindMobile(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="APP\u7b2c\u4e09\u65b9\u5e73\u53f0\u89e3\u9664\u7ed1\u5b9a", notes="APP\u7b2c\u4e09\u65b9\u5e73\u53f0\u89e3\u9664\u7ed1\u5b9a--zln", response=Integer.class)
    @RequestMapping(value={"v1/unBind"}, method={RequestMethod.POST})
    public ResponseEntity unBind(@RequestBody UnBindReq req, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)req);
        ResponseParams responseParams = this.accountService.unBind(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="APP\u7b2c\u4e09\u65b9\u767b\u5f55\u7ed1\u5b9a\u624b\u673a\u53f7", notes="APP\u7b2c\u4e09\u65b9\u767b\u5f55\u7ed1\u5b9a\u624b\u673a\u53f7--zln")
    @RequestMapping(value={"platformBindMobile/v1"}, method={RequestMethod.POST})
    public ResponseEntity platformBindMobile(@RequestBody PlatformBindMobileReq req) {
        RequestUtil.fillHeadParamTl((HeadParamTl)req);
        if (StringUtils.isBlank((String)req.getClientType())) {
            return RestResponseUtils.jointRestResponseNoT((ResponseParams)new ResponseParams(CommonRetCode.PARAM_ERROR));
        }
        ResponseParams responseParams = this.accountService.platformBindMobile(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u767b\u5f55", notes="\u7b2c\u4e09\u65b9\u767b\u5f55--zln")
    @RequestMapping(value={"otherPlatformLogin/v1"}, method={RequestMethod.POST})
    public ResponseEntity otherPlatformLogin(@RequestBody BindAndLoginVo vo) {
        RequestUtil.fillHeadParamTl((HeadParamTl)vo);
        vo.setLoginFrom(Integer.valueOf(0));
        ResponseParams responseParams = this.accountService.otherPlatformLogin(vo);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="APP\u7b2c\u4e09\u65b9\u5e73\u53f0\u7ed1\u5b9a", notes="APP\u7b2c\u4e09\u65b9\u5e73\u53f0\u7ed1\u5b9a--zln")
    @RequestMapping(value={"bind/v1"}, method={RequestMethod.POST})
    public ResponseEntity bind(@RequestBody BindAndLoginVo vo, HttpServletRequest request) throws IOException {
        RequestUtil.fillHeadParamTl((HeadParamTl)vo);
        vo.setLoginFrom(Integer.valueOf(1));
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        vo.setAppUid(uid);
        ResponseParams responseParams = this.accountService.otherPlatformLogin(vo);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", notes="\u9000\u51fa\u767b\u5f55--zln")
    @RequestMapping(value={"v1/logout"}, method={RequestMethod.GET})
    public ResponseEntity logout() {
        ResponseParams logout = this.accountService.logout(ContextUtils.getToken());
        return RestResponseUtils.jointRestResponse((ResponseParams)logout);
    }

    @ApiOperation(value="\u5b8c\u5584\u5b69\u5b50\u4fe1\u606f\u63a5\u53e3", notes="\u5b8c\u5584\u5b69\u5b50\u4fe1\u606f\u63a5\u53e3--zln", response=Boolean.class)
    @RequestMapping(value={"v1/perfectKidInfo"}, method={RequestMethod.POST})
    public ResponseEntity perfectKidInfo(@RequestBody PerfectKidInfoRequest request) {
        try {
            ResponseParams responseParams = this.accountService.perfectKidInfo(request);
            return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7801\u6821\u9a8c", notes="\u9a8c\u8bc1\u7801\u6821\u9a8c--zln", response=boolean.class)
    @RequestMapping(value={"v1/checkCodeConfirm"}, method={RequestMethod.POST})
    public ResponseEntity checkCodeConfirm(@RequestBody CheckCodeConfirmRequest request) {
        log.info("\u9a8c\u8bc1\u7801\u6821\u9a8c:{} ", (Object)request);
        ResponseParams responseParams = this.accountService.checkCodeConfirm(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801\u63a5\u53e3", notes="\u4fee\u6539\u5bc6\u7801\u63a5\u53e3--zln", response=boolean.class)
    @RequestMapping(value={"v1/resetPassword"}, method={RequestMethod.POST})
    public ResponseEntity resetPassword(@RequestBody ResetPasswordRequest request) {
        RequestUtil.fillHeadParamTl((HeadParamTl)request);
        log.info("\u4fee\u6539\u5bc6\u7801\u63a5\u53e3:{} ", (Object)request);
        ResponseParams responseParams = this.accountService.resetPassword(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801\u63a5\u53e3", notes="\u83b7\u53d6\u9a8c\u8bc1\u7801\u63a5\u53e3--zln", response=Boolean.class)
    @GetMapping(value={"/v1/verificationCode"})
    public ResponseEntity sendVerificationCode(@RequestParam(value="phone") String phone, @RequestParam(value="type") String type) {
        log.info("\u83b7\u53d6\u9a8c\u8bc1\u7801\u63a5\u53e3:{}  ", (Object)phone);
        ResponseParams responseParams = this.securityService.sendVerificationCode(phone, type);
        return RestResponseUtils.jointRestResponse((ResponseParams)responseParams);
    }

    @ApiOperation(value="\u7528\u6237\u6ce8\u518c\u63a5\u53e3", notes="\u7528\u6237\u6ce8\u518c\u63a5\u53e3--zln", response=UserDto.class)
    @PostMapping(value={"/v1/register"})
    public ResponseEntity regiser(@RequestBody RegisterRequest request) {
        RequestUtil.fillHeadParamTl((HeadParamTl)request);
        log.info("\u6ce8\u518c\u63a5\u53e3\u5f00\u59cb:{}  ", (Object)JSONObject.toJSONString((Object)request));
        ResponseParams regiser = this.accountService.regiser(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)regiser);
    }

    @ApiOperation(value="APP\u7528\u6237\u767b\u5f55\u63a5\u53e3", notes="APP\u7528\u6237\u767b\u5f55\u63a5\u53e3--zln", response=UserDto.class)
    @RequestMapping(value={"/v1/applogin"}, method={RequestMethod.POST})
    public ResponseEntity applogin(@RequestBody UserLoginRequest request) {
        RequestUtil.fillHeadParamTl((HeadParamTl)request);
        String str = JSONObject.toJSONString((Object)request);
        log.info("APP\u7528\u6237\u767b\u5f55:{}  ", (Object)str);
        String checkResult = ValidationUtils.validateEntity((Object)request);
        if (StringUtils.isNotEmpty((String)checkResult)) {
            return new ResponseEntity((Object)checkResult, HttpStatus.BAD_REQUEST);
        }
        ResponseParams applogin = this.accountService.applogin(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)applogin);
    }

    @ApiOperation(value="\u6e38\u5ba2\u63a5\u53e3", notes="APP\u6e38\u5ba2\u63a5\u53e3--LiBin", response=UserDto.class)
    @PostMapping(value={"/v1/visitorsLogin"})
    public ResponseEntity visitorsLogin(@RequestBody RegisterRequest request) {
        RequestUtil.fillHeadParamTl((HeadParamTl)request);
        log.info("method visitorsLogin param:{}  ", (Object)JSONObject.toJSONString((Object)request));
        ResponseParams result = this.accountService.visitorsLogin(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

