/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.WordListImportService;
import com.ella.resource.api.WordListService;
import com.ella.resource.dto.request.WordCategoryReq;
import com.ella.resource.dto.request.WordListImportReq;
import com.ella.resource.dto.request.WordListReq;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/boeen/wordList/"})
@Api(description="\u5355\u8bcd\u672c")
public class WordListRest {
    private static final Logger log = LogManager.getLogger(WordListRest.class);
    @Autowired
    private WordListService wordListService;
    @Autowired
    private WordListImportService wordListImportService;

    @ApiOperation(value="\u5355\u8bcd\u672c\u5c55\u793a\u7c7b\u522b\u660e\u7ec6")
    @RequestMapping(value={"ListCategoriesByLevel/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> listCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.listCategoriesByLevel(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u5355\u8bcd\u672c\u5c55\u793a\u7b80\u5355\u7c7b\u522b\u660e\u7ec6")
    @RequestMapping(value={"ListSimpleCategoriesByLevel/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> listSimpleCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.listSimpleCategoriesByLevel(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u7c7b\u522b\u8be6\u60c5")
    @RequestMapping(value={"showCategoryByCode/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> showCategoryByCode(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.showCategoryByCode(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u66f4\u65b0\uff08\u5220\u9664\uff09\u67d0\u7c7b\u522b")
    @RequestMapping(value={"updateCategory/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateCategory(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.updateCategory(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u66f4\u65b0\u7c7b\u522b\u6392\u5e8f")
    @RequestMapping(value={"updateCategoryIdx/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateCategoryIdx(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.updateCategoryIdx(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u65b0\u589e\u67d0\u4e2a\u7c7b\u522b")
    @RequestMapping(value={"insertCategory/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> insertCategory(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.insertCategory(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u67e5\u627e\u67d0\u7c7b\u522b")
    @RequestMapping(value={"searchCategory/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> searchCategory(@RequestBody WordCategoryReq wordCategoryReq) {
        ResponseParams params = this.wordListService.searchCategory(wordCategoryReq);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u65b0\u589e\u67d0\u4e2a\u5355\u8bcd")
    @RequestMapping(value={"insertWord/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> insertWord(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.insertWord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u68c0\u67e5\u67d0\u4e2a\u5355\u8bcd\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"checkWordExist/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> checkWordExist(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.checkWordExist(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u66f4\u65b0\u67d0\u4e2a\u5355\u8bcd")
    @RequestMapping(value={"updateWord/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateWord(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.updateWord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u5173\u952e\u5b57\u641c\u7d22\u67d0\u4e2a\u5355\u8bcd")
    @RequestMapping(value={"searchWord/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> searchWord(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.searchWord(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u67e5\u770b\u5355\u8bcd\u8be6\u60c5")
    @RequestMapping(value={"showOneWordMsg/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> showOneWordMsg(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.showOneWordMsg(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u67e5\u770b\u67d0\u7b49\u7ea7\u4e0b\u67d0\u7c7b\u522b\u5217\u8868")
    @RequestMapping(value={"listWordsByRelationCode/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> listWordsByRelationCode(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.listWordsByRelationCode(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u5355\u8bcd\u672c\u5bfc\u5165\u5355\u8bcdexcel")
    @RequestMapping(value={"importWordListExcel/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> importWordListExcel(@RequestPart(value="file", required=false) MultipartFile file) {
        ResponseParams params = this.wordListImportService.importWordListExcel(file);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u5bfc\u5165\u7684\u5355\u8bcd\u63d2\u5165\u6570\u636e\u5e93")
    @RequestMapping(value={"importWordListToDb/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> importWordListToDb(@RequestBody WordListImportReq req) {
        ResponseParams params = this.wordListImportService.importWordListToDb(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }

    @ApiOperation(value="\u5355\u8bcd\u5728\u67d0\u7c7b\u522b\u4e0b\u6392\u5e8f")
    @RequestMapping(value={"updateWordIdx/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateWordIdx(@RequestBody WordListReq req) {
        ResponseParams params = this.wordListService.updateWordIdx(req);
        return RestResponseUtils.jointRestResponse((ResponseParams)params);
    }
}

