/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.MissionService;
import com.ella.resource.api.UserMapAndMissionSnapshotService;
import com.ella.resource.dto.UpdateStoneNumDto;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.PicBookMissionDto;
import com.ella.resource.dto.appdto.UserMissionListDto;
import com.ella.resource.dto.missiondto.MissionDetailPageDto;
import com.ella.resource.dto.missiondto.MissionDto;
import com.ella.resource.dto.missiondto.MissionFullDto;
import com.ella.resource.dto.missiondto.MissionSetDto;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.map.MapResourceDeleteRequest;
import com.ella.resource.dto.request.map.MapResourceSaveRequest;
import com.ella.resource.dto.request.mission.GetMissionDetailPageRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionLevelListRequest;
import com.ella.resource.dto.request.mission.GetMissionListRequest;
import com.ella.resource.dto.request.mission.MoveMissionRequest;
import com.ella.resource.dto.request.mission.SaveMissionRequest;
import com.ella.resource.dto.request.mission.UpdateMissionRequest;
import com.ella.rest.util.RestResponseUtils;
import com.ella.user.utils.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u5173\u5361\u76f8\u5173\u63a5\u53e3")
public class MissionRest {
    private static final Logger log = LogManager.getLogger(MissionRest.class);
    @Autowired
    private MissionService missionService;
    @Autowired
    private UserMapAndMissionSnapshotService userMapAndMissionService;

    @ApiOperation(value="\u5173\u5361\u5217\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u5173\u5361\u5217\u8868\u63a5\u53e3--LiBin", response=MissionSetDto.class)
    @RequestMapping(path={"getMissionList/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMissionList(@RequestBody GetMissionListRequest request) {
        ResponseParams result = this.missionService.getMissionList(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5173\u5361\u8be6\u60c5\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u83b7\u53d6\u5173\u5361\u8be6\u60c5\u63a5\u53e3--LiBin", response=MissionDto.class)
    @RequestMapping(path={"getMissionInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMissionInfo(@RequestBody GetMissionInfoRequest request) {
        ResponseParams result = this.missionService.getMissionInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5173\u5361\u65b0\u589e\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5173\u5361\u65b0\u589e\u63a5\u53e3--LiBin", response=Integer.class)
    @RequestMapping(path={"saveMission/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> saveMission(@RequestBody SaveMissionRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.missionService.saveMission(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5173\u5361\u7f16\u8f91\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5173\u5361\u7f16\u8f91\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"updateMission/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateMission(@RequestBody UpdateMissionRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.missionService.updateMission(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5173\u5361\u79fb\u52a8\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5173\u5361\u79fb\u52a8\u63a5\u53e3--Cui", response=Boolean.class)
    @RequestMapping(path={"moveMission/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> moveMission(@RequestBody MoveMissionRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.missionService.moveMission(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5173\u5361\u5220\u9664\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5173\u5361\u5220\u9664\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"deleteMission/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> deleteMission(@RequestBody GetMissionInfoRequest request) {
        request.setUid(ContextUtils.getUid());
        ResponseParams result = this.missionService.deleteMission(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5730\u56fe\u8d44\u6e90\u65b0\u589e\u63a5\u53e3--OTS(\u5e9f\u5f03)", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u8d44\u6e90\u65b0\u589e\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"saveMapResource/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateMapResource(@RequestBody MapResourceSaveRequest request) {
        request.setUid(ContextUtils.getUid());
        return RestResponseUtils.jointRestResponse((ResponseParams)this.missionService.saveMapResource(request));
    }

    @ApiOperation(value="\u5730\u56fe\u8d44\u6e90\u5220\u9664\u63a5\u53e3--OTS(\u5e9f\u5f03)", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u8d44\u6e90\u5220\u9664\u63a5\u53e3--LiBin", response=Boolean.class)
    @RequestMapping(path={"deleteMapResource/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> deleteMapResource(@RequestBody MapResourceDeleteRequest request) {
        request.setUid(ContextUtils.getUid());
        return RestResponseUtils.jointRestResponse((ResponseParams)this.missionService.deleteMapResource(request));
    }

    @ApiOperation(value="\u5730\u56fe\u8d44\u6e90\u7f16\u8f91\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177\u5730\u56fe\u8d44\u6e90\u7f16\u8f91\u63a5\u53e3--LiBin", response=Boolean.class)
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    @RequestMapping(path={"updateMapResource/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateMapResource(@RequestBody MissionSetDto dto) {
        return RestResponseUtils.jointRestResponse((ResponseParams)this.missionService.updateMapResource(dto));
    }

    @ApiOperation(value="\u6211\u7684\u5173\u5361\u5217\u8868--APP", notes="APP\u6211\u7684\u5173\u5361\u5217\u8868\u63a5\u53e3--LiBin", response=UserMissionListDto.class)
    @RequestMapping(path={"selectUserMission/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> selectUserMission(@RequestBody GetMapInfoRequest request, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.userMapAndMissionService.selectUserMission(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u5361\u53ca\u5173\u8054\u7b49\u7ea7\u5730\u56fe\u4fe1\u606f\u5217\u8868--OTS", notes="\u67e5\u8be2\u5173\u5361\u5217\u8868,\u8fd4\u56de\u5173\u8054\u7b49\u7ea7\u5730\u56fe\u4fe1\u606f--chenshuai", response=MissionFullDto.class)
    @RequestMapping(path={"getMissionAndLevelList/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMissionAndLevelList(@RequestBody GetMissionLevelListRequest request) {
        ResponseParams result = this.missionService.getMissionAndLevelList(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u6211\u7684\u8bfe\u7a0b\u5173\u5361\u8be6\u60c5--APP", notes="APP\u6211\u7684\u8bfe\u7a0b\u5173\u5361\u8be6\u60c5\u63a5\u53e3--LiBin", response=CourseMissionDto.class)
    @RequestMapping(path={"userMissionInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> userMissionInfo(@RequestBody GetMissionInfoRequest request, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.userMapAndMissionService.userMissionInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result, (boolean)true);
    }

    @ApiOperation(value="\u6211\u7684\u7ed8\u672c\u5173\u5361\u8be6\u60c5--APP", notes="APP\u6211\u7684\u7ed8\u672c\u5173\u5361\u8be6\u60c5\u63a5\u53e3--LiBin", response=PicBookMissionDto.class)
    @RequestMapping(path={"userPicMissionInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> userPicMissionInfo(@RequestBody GetMissionInfoRequest request, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.userMapAndMissionService.userPicMissionInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u9636\u6bb5\u6027\u6d4b\u9a8c\u3001\u8003\u8bd5\u7684\u5173\u5361\u8be6\u60c5\u9875\u4fe1\u606f\u63a5\u53e3--APP", notes="APP\u83b7\u53d6\u9636\u6bb5\u6027\u6d4b\u9a8c\u3001\u8003\u8bd5\u7684\u5173\u5361\u8be6\u60c5\u9875\u4fe1\u606f\u63a5\u53e3--zhaojl", response=MissionDetailPageDto.class)
    @RequestMapping(path={"missionDetailPageInfo/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> missionDetailPageInfo(@RequestBody GetMissionDetailPageRequest request) {
        ResponseParams result = this.missionService.missionDetailPageInfo(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u66f4\u65b0\u6700\u65b0\u7684\u80fd\u91cf\u77f3\u6570\u63a5\u53e3--APP", notes="\u66f4\u65b0\u6700\u65b0\u7684\u80fd\u91cf\u77f3\u6570\u63a5\u53e3--wangshuzheng", response=Boolean.class)
    @RequestMapping(path={"updateStoneNum/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateStoneNum(@RequestBody UpdateStoneNumDto request, HttpServletRequest request1) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)request1, (Object)request);
        ResponseParams result = this.missionService.updateStoneNum(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

