/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.HeadParamInitializationUtil;
import com.ella.resource.api.GenerateOneIraReportService;
import com.ella.resource.api.IraReportService;
import com.ella.resource.api.MissionReportService;
import com.ella.resource.dto.IraReadRecordDto;
import com.ella.resource.dto.IraReportDto;
import com.ella.resource.dto.MissionReportDto;
import com.ella.resource.dto.request.ira.GetIraReportRequest;
import com.ella.resource.dto.request.ira.ReadRecordIraRequest;
import com.ella.resource.dto.request.mission.GetMissionReportRequest;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u5173\u5361\u62a5\u8868\u76f8\u5173\u63a5\u53e3")
public class MissionReportRest {
    private static final Logger log = LogManager.getLogger(MissionReportRest.class);
    @Autowired
    MissionReportService service;
    @Autowired
    IraReportService iraReportService;
    @Autowired
    GenerateOneIraReportService generateOneIraReportService;

    @ApiOperation(value="\u83b7\u53d6\u5173\u5361\u62a5\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u83b7\u53d6\u5173\u5361\u62a5\u8868\u63a5\u53e3--zhaojinliang", response=MissionReportDto.class)
    @RequestMapping(path={"getMissionReports/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getMissionReports(@RequestBody GetMissionReportRequest request) {
        log.info("\u83b7\u53d6\u5173\u5361\u62a5\u8868\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)request));
        ResponseParams result = this.service.getMissionReports(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u4e0a\u4f20\u672c\u6b21\u5173\u5361\u9605\u8bfb\u5668\u65f6\u957f", notes="IRA\u63a5\u53e3-\u4e0a\u4f20\u672c\u6b21\u5173\u5361\u9605\u8bfb\u5668\u65f6\u957f--mengyang", response=IraReadRecordDto.class)
    @RequestMapping(path={"readRecordIra/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> uploadReadRecordIra(@RequestBody ReadRecordIraRequest readRecordIraRequest, HttpServletRequest httpServletRequest) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)httpServletRequest, (Object)readRecordIraRequest);
        ResponseParams result = this.iraReportService.insertReadRecordIra(readRecordIraRequest);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6IRA\u62a5\u544a", notes="IRA\u63a5\u53e3-\u83b7\u53d6IRA\u62a5\u544a--lyy", response=IraReportDto.class)
    @RequestMapping(path={"getIraReport/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getIraReport(@RequestBody GetIraReportRequest request, HttpServletRequest httpServletRequest) throws Exception {
        HeadParamInitializationUtil.InitializationUid((HttpServletRequest)httpServletRequest, (Object)request);
        ResponseParams result = this.iraReportService.getIraReport(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u83b7\u53d6IRA\u62a5\u544a\u66f4\u65b0\u72b6\u6001", notes="IRA\u63a5\u53e3-\u83b7\u53d6IRA\u62a5\u544a\u66f4\u65b0\u72b6\u6001--mengyang", response=IraReportDto.class)
    @RequestMapping(path={"getIraReportUpdateStatus/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getIraReportUpdateStatus(HttpServletRequest request) throws IOException {
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        ResponseParams res = this.iraReportService.getIraReportUpdateStatus(uid);
        res.setRemark("\u83b7\u53d6IRA\u62a5\u544a\u66f4\u65b0\u72b6\u6001");
        return RestResponseUtils.jointRestResponse((ResponseParams)res);
    }

    @ApiOperation(value="\u751f\u6210\u4e00\u4e2a\u4eba\u7684\u9605\u8bfb\u62a5\u544a", notes="IRA\u63a5\u53e3-\u751f\u6210\u4e00\u4e2a\u4eba\u7684\u9605\u8bfb\u62a5\u544a--mengyang", response=IraReportDto.class)
    @RequestMapping(path={"generateOneIraReport/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> generateOneIraReport(HttpServletRequest request) throws Exception {
        String uid = HeadParamInitializationUtil.InitializationForUid((HttpServletRequest)request);
        ResponseParams res = this.generateOneIraReportService.generateOneReport(uid);
        res.setRemark("\u751f\u6210\u4e00\u4e2a\u4eba\u7684\u9605\u8bfb\u62a5\u544a");
        return RestResponseUtils.jointRestResponse((ResponseParams)res);
    }

    @ApiOperation(value="\u751f\u6210\u6240\u6709\u4eba\u7684\u9605\u8bfb\u62a5\u544a", notes="IRA\u63a5\u53e3-\u751f\u6210\u6240\u6709\u7684\u9605\u8bfb\u62a5\u544a--mengyang", response=IraReportDto.class)
    @RequestMapping(path={"generateAllIraReport/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> generateAllIraReport() {
        ResponseParams res = this.generateOneIraReportService.generateAllIraReport();
        res.setRemark("\u6240\u6709\u4eba\u7684\u9605\u8bfb\u62a5\u544a\u6b63\u5728\u751f\u6210\u4e2d\u3002\u3002\u3002");
        return RestResponseUtils.jointRestResponse((ResponseParams)res);
    }
}

