/*
 * Decompiled with CFR 0.152.
 */
package com.ella.rest.resource;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.api.LexileEvaluationService;
import com.ella.resource.dto.LexileEvaluationListDto;
import com.ella.resource.dto.LexileEvaluationPageDto;
import com.ella.resource.dto.LexileEvaluationQuestionDto;
import com.ella.resource.dto.request.lexile.EditLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.FindLexileQuestionItemRequest;
import com.ella.resource.dto.request.lexile.ModifyLexileEvaluationInfRequest;
import com.ella.resource.dto.request.lexile.SaveLexileEvaluationRequest;
import com.ella.resource.dto.request.lexile.SelectOneLexileQuestionsRequest;
import com.ella.rest.util.RestResponseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/en/resource/"})
@Api(description="\u84dd\u601d\u9898\u5e93\u76f8\u5173\u63a5\u53e3")
public class LexileEvalRest {
    private static final Logger log = LogManager.getLogger(LexileEvalRest.class);
    @Autowired
    LexileEvaluationService service;

    @ApiOperation(value="\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"saveLexileEvaluation/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> saveLexileEvaluation(@RequestBody SaveLexileEvaluationRequest request) {
        log.info("\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.service.saveLexileEvaluation(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u4fee\u6539\u84dd\u601d\u8bc4\u6d4b\u7b49\u7ea7\u5bf9\u5e94\u4fe1\u606f--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u4fee\u6539\u84dd\u601d\u8bc4\u6d4b\u7b49\u7ea7\u5bf9\u5e94\u4fe1\u606f--chenshuai", response=Boolean.class)
    @RequestMapping(path={"modifyLexileEvaluationInf/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> modifyLexileEvaluationInf(@RequestBody ModifyLexileEvaluationInfRequest request) {
        log.info("\u4fee\u6539\u84dd\u601d\u8bc4\u6d4b\u7b49\u7ea7\u5bf9\u5e94\u4fe1\u606f,req:{}", (Object)JSONObject.toJSONString((Object)request));
        ResponseParams result = this.service.modifyLexileEvaluationInf(request);
        log.info("\u4fee\u6539\u84dd\u601d\u8bc4\u6d4b\u7b49\u7ea7\u5bf9\u5e94\u4fe1\u606f,resposne:{}", (Object)JSONObject.toJSONString((Object)result));
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5217\u8868\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u6dfb\u52a0\u84dd\u601d\u8bc4\u6d4b\u5217\u8868\u63a5\u53e3--zhaojinliang", response=LexileEvaluationListDto.class)
    @RequestMapping(path={"getAllLexileEvaluation/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> getAllLexileEvaluation() {
        log.info("\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5217\u8868");
        ResponseParams result = this.service.getAllLexileInfo();
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5355\u4e2a\u9898\u76ee\u8be6\u60c5\u63a5\u53e3--OTS/app", notes="\u8fd0\u8425\u5de5\u5177/app-\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5355\u4e2a\u9898\u76ee\u8be6\u60c5\u63a5\u53e3--zhaojinliang", response=LexileEvaluationQuestionDto.class)
    @RequestMapping(path={"queryLexiLeEvaluationDetail/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> queryLexiLeEvaluationDetail(@RequestBody FindLexileQuestionItemRequest request) {
        log.info("\u67e5\u8be2\u84dd\u601d\u8bc4\u6d4b\u5355\u4e2a\u9898\u76ee\u8be6\u60c5\u63a5\u53e3," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.service.queryLexiLeEvaluationDetail(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u7f16\u8f91\u84dd\u601d\u8bc4\u6d4b\u9898\u76ee\u5c5e\u6027\u503c\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u7f16\u8f91\u84dd\u601d\u8bc4\u6d4b\u9898\u76ee\u5c5e\u6027\u503c\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"updateLexiLeEvaluationProperty/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> updateLexiLeEvaluationProperty(@RequestBody EditLexileEvaluationRequest request) {
        log.info("\u7f16\u8f91\u84dd\u601d\u8bc4\u6d4b\u6d88\u8017\u80fd\u91cf\u503c," + JSONObject.toJSONString((Object)request));
        ResponseParams result = this.service.updateLexiLeEvaluationProperty(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u5bfc\u5165\u84dd\u601d\u9898\u76ee\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u5bfc\u5165\u84dd\u601d\u9898\u76ee\u63a5\u53e3--zhaojinliang", response=Boolean.class)
    @RequestMapping(path={"importLexileEvaluation/v1"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_OTS')")
    public ResponseEntity<?> importLexileEvaluation(@RequestParam(value="file") MultipartFile file, @RequestParam(value="evaluationId") String evaluationId) {
        ResponseParams result = this.service.importLexileEvaluation(file, evaluationId);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }

    @ApiOperation(value="\u67e5\u770b\u6307\u5b9a\u8bc4\u6d4b\u7684\u6240\u6709\u9898\u76ee\u63a5\u53e3--OTS", notes="\u8fd0\u8425\u5de5\u5177-\u67e5\u770b\u6307\u5b9a\u8bc4\u6d4b\u7684\u6240\u6709\u9898\u76ee\u63a5\u53e3--zhaojinliang", response=LexileEvaluationPageDto.class)
    @RequestMapping(path={"getOneLexileQuestions/v1"}, method={RequestMethod.POST})
    public ResponseEntity<?> getOneLexileQuestions(@RequestBody SelectOneLexileQuestionsRequest request) {
        ResponseParams result = this.service.getOneLexileQuestions(request);
        return RestResponseUtils.jointRestResponse((ResponseParams)result);
    }
}

